/*
 * Decompiled with CFR 0.152.
 */
package io.github.netmikey.logunit.jul;

import io.github.netmikey.logunit.core.BaseLogProvider;
import io.github.netmikey.logunit.jul.LevelMapper;
import io.github.netmikey.logunit.jul.ListHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Marker;
import org.slf4j.event.LoggingEvent;

public class JulLogProvider
extends BaseLogProvider {
    private final ListHandler listHandler = new ListHandler();
    private final Map<String, Level> originalLevels = new HashMap<String, Level>();

    public void provideForType(Class<?> type, org.slf4j.event.Level level) {
        this.provideForLogger(type.getName(), level);
    }

    public List<LoggingEvent> getEvents() {
        return StreamSupport.stream(this.listHandler.spliterator(), false).map(this::mapEvent).collect(Collectors.toList());
    }

    public void beforeTestExecution(ExtensionContext context) {
        this.addAppenderToLoggingSources();
    }

    public void afterTestExecution(ExtensionContext context) {
        this.listHandler.flush();
        this.listHandler.close();
        this.detachAppenderFromLoggingSources();
    }

    private void addAppenderToLoggingSources() {
        this.getLoggerNames().forEach((loggerName, level) -> this.addAppenderToLogger((String)loggerName, LevelMapper.mapLevel(level)));
    }

    private void detachAppenderFromLoggingSources() {
        this.getLoggerNames().keySet().forEach(this::detachAppenderFromLogger);
    }

    private void addAppenderToLogger(String name, Level level) {
        this.addAppenderToLogger(Logger.getLogger(name), level);
    }

    private void addAppenderToLogger(Logger logger, Level level) {
        logger.addHandler(this.listHandler);
        this.originalLevels.put(logger.getName(), logger.getLevel());
        logger.setLevel(level);
    }

    private void detachAppenderFromLogger(String name) {
        this.detachAppenderFromLogger(Logger.getLogger(name));
    }

    private void detachAppenderFromLogger(Logger logger) {
        logger.removeHandler(this.listHandler);
        Level originalLevel = this.originalLevels.get(logger.getName());
        if (originalLevel != null) {
            logger.setLevel(originalLevel);
        }
    }

    private LoggingEvent mapEvent(final LogRecord record) {
        return new LoggingEvent(){

            public long getTimeStamp() {
                return record.getMillis();
            }

            public Throwable getThrowable() {
                return record.getThrown();
            }

            public String getThreadName() {
                return String.valueOf(record.getThreadID());
            }

            public String getMessage() {
                return record.getMessage();
            }

            public Marker getMarker() {
                return null;
            }

            public String getLoggerName() {
                return record.getLoggerName();
            }

            public org.slf4j.event.Level getLevel() {
                return LevelMapper.mapLevel(record.getLevel());
            }

            public Object[] getArgumentArray() {
                return record.getParameters();
            }
        };
    }
}

