/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.utils.NetworkUtils;

public final class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String streamToString(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            return br.lines().collect(Collectors.joining());
        }
        catch (Exception e) {
            log.error("Error converting stream to string", (Throwable)e);
            return null;
        }
    }

    public static String getResourceAbsoluteDirectory(ClassLoader cl, String resource) {
        try {
            URL res = cl.getResource(resource);
            if (res == null) {
                throw new Error("Cannot get integrated resource " + resource);
            }
            return Paths.get(res.toURI()).toFile().getAbsolutePath();
        }
        catch (Exception e) {
            throw new Error("Cannot get absolute directory of resource " + resource);
        }
    }

    public static String getLocalOrDownload(String linkToFile) {
        if (linkToFile.contains("http") && linkToFile.contains("://")) {
            try {
                URL url = new URL(linkToFile);
                String filename = FilenameUtils.getName((String)url.getPath());
                File tmpFile = new File(filename);
                if (!tmpFile.exists()) {
                    log.info("downloading {}", (Object)linkToFile);
                    org.apache.commons.io.FileUtils.copyURLToFile((URL)url, (File)tmpFile);
                    tmpFile.setExecutable(true);
                }
                return tmpFile.getAbsolutePath();
            }
            catch (Exception e) {
                log.error("Error downloading file", (Throwable)e);
                throw new Error("Cannot download file. Error " + e.getMessage());
            }
        }
        return linkToFile;
    }

    public static String getLibraryExtension() {
        NetworkUtils.OS os = NetworkUtils.getOS();
        if (os == NetworkUtils.OS.WINDOWS || os == NetworkUtils.OS.WINDOWS_ARM) {
            return "dll";
        }
        if (os == NetworkUtils.OS.MAC || os == NetworkUtils.OS.MAC_ARM64) {
            return "dylib";
        }
        return "so";
    }

    public static String getArtifactExtension(String artifactName) {
        NetworkUtils.OS os = NetworkUtils.getOS();
        if (artifactName.contains("emulator") || artifactName.contains("tonlib")) {
            if (os == NetworkUtils.OS.WINDOWS || os == NetworkUtils.OS.WINDOWS_ARM) {
                return ".dll";
            }
            if (os == NetworkUtils.OS.MAC || os == NetworkUtils.OS.MAC_ARM64) {
                return ".dylib";
            }
            return ".so";
        }
        if (os == NetworkUtils.OS.WINDOWS || os == NetworkUtils.OS.WINDOWS_ARM) {
            return ".exe";
        }
        return "";
    }

    public static String detectAbsolutePath(String appName, boolean library) {
        try {
            NetworkUtils.OS os;
            if (library) {
                appName = (String)appName + "." + FileUtils.getLibraryExtension();
            }
            ProcessBuilder pb = (os = NetworkUtils.getOS()) == NetworkUtils.OS.WINDOWS || os == NetworkUtils.OS.WINDOWS_ARM ? new ProcessBuilder(new String[]{"where", appName}).redirectErrorStream(true) : new ProcessBuilder(new String[]{"which", appName}).redirectErrorStream(true);
            Process p = pb.start();
            p.waitFor(1L, TimeUnit.SECONDS);
            String output = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            String[] paths = output.split("\n");
            if (paths.length == 1) {
                return paths[0];
            }
            for (String path : paths) {
                if (!path.contains("ton")) continue;
                return StringUtils.trim((String)path);
            }
            return null;
        }
        catch (Exception e) {
            throw new Error("Cannot detect absolute path to executable " + (String)appName + ", " + e.getMessage());
        }
    }

    public static String getLiteClientGithubUrl() {
        return FileUtils.getArtifactGithubUrl("lite-client", "");
    }

    public static String getEmulatorGithubUrl() {
        return FileUtils.getArtifactGithubUrl("libemulator", "");
    }

    public static String getTonlibGithubUrl() {
        return FileUtils.getArtifactGithubUrl("tonlibjson", "");
    }

    public static String getFuncGithubUrl() {
        return FileUtils.getArtifactGithubUrl("func", "");
    }

    public static String getTolkGithubUrl() {
        return FileUtils.getArtifactGithubUrl("tolk", "");
    }

    public static String getFiftGithubUrl() {
        return FileUtils.getArtifactGithubUrl("fift", "");
    }

    public static String getArtifactGithubUrl(String artifactName, String release) {
        return FileUtils.getArtifactGithubUrl(artifactName, release, "ton-blockchain", "ton");
    }

    public static String getArtifactGithubUrl(String artifactName, String release, String githubUsername, String githubRepository) {
        String baseUrl = StringUtils.isNotEmpty((CharSequence)release) && !release.contains("latest") ? "https://github.com/" + githubUsername + "/" + githubRepository + "/releases/download/" + release + "/" : "https://github.com/" + githubUsername + "/" + githubRepository + "/releases/latest/download/";
        NetworkUtils.OS os = NetworkUtils.getOS();
        if (os == NetworkUtils.OS.WINDOWS || os == NetworkUtils.OS.WINDOWS_ARM) {
            return baseUrl + artifactName + FileUtils.getArtifactExtension(artifactName);
        }
        if (os == NetworkUtils.OS.MAC) {
            return baseUrl + artifactName + "-mac-x86-64" + FileUtils.getArtifactExtension(artifactName);
        }
        if (os == NetworkUtils.OS.MAC_ARM64) {
            return baseUrl + artifactName + "-mac-arm64" + FileUtils.getArtifactExtension(artifactName);
        }
        if (os == NetworkUtils.OS.LINUX) {
            return baseUrl + artifactName + "-linux-x86_64" + FileUtils.getArtifactExtension(artifactName);
        }
        if (os == NetworkUtils.OS.LINUX_ARM) {
            return baseUrl + artifactName + "-linux-arm64" + FileUtils.getArtifactExtension(artifactName);
        }
        throw new Error("unknown requested OS");
    }

    public static String getGlobalConfigUrlMainnet() {
        return "https://ton.org/global-config.json";
    }

    public static String getGlobalConfigUrlTestnet() {
        return "https://ton.org/testnet-global.config.json";
    }

    public static String getGlobalConfigUrlMainnetGithub() {
        return "https://raw.githubusercontent.com/ton-blockchain/ton-blockchain.github.io/main/global.config.json";
    }

    public static String getGlobalConfigUrlTestnetGithub() {
        return "https://raw.githubusercontent.com/ton-blockchain/ton-blockchain.github.io/main/testnet-global.config.json";
    }
}

