/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

public final class AnsiColors {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    public static final String ANSI_BLACK_BACKGROUND = "\u001b[40m";
    public static final String ANSI_RED_BACKGROUND = "\u001b[41m";
    public static final String ANSI_GREEN_BACKGROUND = "\u001b[42m";
    public static final String ANSI_YELLOW_BACKGROUND = "\u001b[43m";
    public static final String ANSI_BLUE_BACKGROUND = "\u001b[44m";
    public static final String ANSI_PURPLE_BACKGROUND = "\u001b[45m";
    public static final String ANSI_CYAN_BACKGROUND = "\u001b[46m";
    public static final String ANSI_WHITE_BACKGROUND = "\u001b[47m";
    public static final String ANSI_BOLD = "\u001b[1m";
    public static final String ANSI_UNDERLINE = "\u001b[4m";
    public static final String ANSI_BLINK = "\u001b[5m";
    public static final String ANSI_REVERSE = "\u001b[7m";
    public static final String ANSI_HIDDEN = "\u001b[8m";

    private AnsiColors() {
    }

    public static String colorize(String text, String color) {
        return color + text + ANSI_RESET;
    }

    public static String colorize(String text, String color, String background) {
        return color + background + text + ANSI_RESET;
    }

    public static String red(String text) {
        return AnsiColors.colorize(text, ANSI_RED);
    }

    public static String green(String text) {
        return AnsiColors.colorize(text, ANSI_GREEN);
    }

    public static String yellow(String text) {
        return AnsiColors.colorize(text, ANSI_YELLOW);
    }

    public static String blue(String text) {
        return AnsiColors.colorize(text, ANSI_BLUE);
    }

    public static String purple(String text) {
        return AnsiColors.colorize(text, ANSI_PURPLE);
    }

    public static String cyan(String text) {
        return AnsiColors.colorize(text, ANSI_CYAN);
    }

    public static String bold(String text) {
        return ANSI_BOLD + text + ANSI_RESET;
    }

    public static String underline(String text) {
        return ANSI_UNDERLINE + text + ANSI_RESET;
    }
}

