/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tonlib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.util.ArrayList;
import java.util.Objects;
import org.ton.java.tonlib.types.SmcLibraryEntry;
import org.ton.java.tonlib.types.SmcLibraryResult;

public class LibraryResultParser {
    Gson customGson;

    LibraryResultParser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        JsonDeserializer deserializerLibraryEntry = (json, typeOfT, context) -> {
            String hash = json.getAsJsonObject().get("hash").getAsString();
            String data = json.getAsJsonObject().get("data").getAsString();
            return SmcLibraryEntry.builder().hash(hash).data(data).build();
        };
        JsonDeserializer deserializerLibraryResult = (json, typeOfT, context) -> {
            SmcLibraryResult smcLibraryResult = SmcLibraryResult.builder().build();
            ArrayList<SmcLibraryEntry> elements = new ArrayList<SmcLibraryEntry>();
            JsonArray elementsArray = json.getAsJsonObject().getAsJsonArray("result");
            if (Objects.nonNull(elementsArray)) {
                for (int j = 0; j < elementsArray.size(); ++j) {
                    JsonElement element = elementsArray.get(j);
                    String elementType = element.getAsJsonObject().get("@type").getAsString();
                    elements.add((SmcLibraryEntry)context.deserialize(element, SmcLibraryEntry.class));
                }
            }
            smcLibraryResult.setResult(elements);
            return smcLibraryResult;
        };
        gsonBuilder.registerTypeAdapter(SmcLibraryEntry.class, (Object)deserializerLibraryEntry);
        gsonBuilder.registerTypeAdapter(SmcLibraryResult.class, (Object)deserializerLibraryResult);
        this.customGson = gsonBuilder.setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.BIG_DECIMAL).create();
    }

    public SmcLibraryResult parse(String getLibResult) {
        return (SmcLibraryResult)this.customGson.fromJson(getLibResult, SmcLibraryResult.class);
    }

    private Object deserializeByType(String type, JsonElement jsonElement, JsonDeserializationContext context) {
        if (type.equals("smc.libraryEntry")) {
            return context.deserialize(jsonElement, SmcLibraryEntry.class);
        }
        if (type.equals("smc.libraryResult")) {
            return context.deserialize(jsonElement, SmcLibraryResult.class);
        }
        return null;
    }
}

