/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tolk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.utils.Utils;

public class TolkRunner {
    private static final Logger log = LoggerFactory.getLogger(TolkRunner.class);
    public String tolkExecutablePath;
    public String tolkStdLibPath;
    private Boolean printInfo;
    public static String tolkExecutable = "";

    public static TolkRunnerBuilder builder() {
        return new CustomTolkRunnerBuilder();
    }

    public String run(String workdir, String ... params) {
        Pair<Process, String> result = this.execute(tolkExecutable, workdir, params);
        if (result != null && result.getRight() != null) {
            return (String)result.getRight();
        }
        return "";
    }

    public String getTolkSystemPath() {
        return Utils.detectAbsolutePath((String)"tolk", (boolean)false);
    }

    public Pair<Process, String> execute(String pathToBinary, String workDir, String ... command) {
        Object[] withBinaryCommand = new String[]{pathToBinary};
        withBinaryCommand = (String[])ArrayUtils.addAll((Object[])withBinaryCommand, (Object[])command);
        try {
            if (this.printInfo.booleanValue()) {
                log.info("execute: " + String.join((CharSequence)" ", (CharSequence[])withBinaryCommand));
            }
            ProcessBuilder pb = new ProcessBuilder((String[])withBinaryCommand).redirectErrorStream(true);
            pb.directory(new File(workDir));
            if (StringUtils.isNotEmpty((CharSequence)this.tolkStdLibPath)) {
                Map<String, String> env = pb.environment();
                env.put("TOLK_STDLIB", this.tolkStdLibPath);
            }
            Process p = pb.start();
            p.waitFor(1L, TimeUnit.SECONDS);
            String resultInput = IOUtils.toString((InputStream)p.getInputStream(), (Charset)Charset.defaultCharset());
            p.getInputStream().close();
            p.getErrorStream().close();
            p.getOutputStream().close();
            if (p.exitValue() == 2 || p.exitValue() == 0) {
                return Pair.of((Object)p, (Object)resultInput);
            }
            log.error("exit value {}", (Object)p.exitValue());
            log.error(resultInput);
            throw new Exception("Error running " + String.valueOf(withBinaryCommand));
        }
        catch (IOException e) {
            log.info(e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    TolkRunner(String tolkExecutablePath, String tolkStdLibPath, Boolean printInfo) {
        this.tolkExecutablePath = tolkExecutablePath;
        this.tolkStdLibPath = tolkStdLibPath;
        this.printInfo = printInfo;
    }

    private static class CustomTolkRunnerBuilder
    extends TolkRunnerBuilder {
        private CustomTolkRunnerBuilder() {
        }

        @Override
        public TolkRunner build() {
            if (Objects.isNull(this.printInfo)) {
                this.printInfo = true;
            }
            if (StringUtils.isEmpty((CharSequence)this.tolkExecutablePath)) {
                if (this.printInfo.booleanValue()) {
                    log.info("Checking if Tolk is installed...");
                }
                String errorMsg = "You can specify full path via TolkRunner.builder().tolkExecutablePath(Utils.getTolkGithubUrl()).\nOr make sure you have Tolk installed. See https://github.com/ton-blockchain/packages for instructions.";
                try {
                    ProcessBuilder pb = new ProcessBuilder("tolk", "-h").redirectErrorStream(true);
                    Process p = pb.start();
                    p.waitFor(1L, TimeUnit.SECONDS);
                    if (p.exitValue() != 2) {
                        throw new Error("Cannot execute simple Tolk command.\n" + errorMsg);
                    }
                    String tolkAbsolutePath = Utils.detectAbsolutePath((String)"tolk", (boolean)false);
                    if (StringUtils.isEmpty((CharSequence)this.tolkStdLibPath)) {
                        this.tolkStdLibPath = this.getTolkSystemStdLibPath();
                    }
                    if (this.printInfo.booleanValue()) {
                        log.info("Tolk found at {}, TOLK_STDLIB={} ", (Object)tolkAbsolutePath, (Object)this.tolkStdLibPath);
                    }
                    tolkExecutable = "tolk";
                }
                catch (Exception e) {
                    log.info(e.getMessage());
                    throw new Error("Cannot execute simple Tolk command.\n" + errorMsg);
                }
            }
            if (this.tolkExecutablePath.contains("http") && this.tolkExecutablePath.contains("://")) {
                try {
                    String smartcont = StringUtils.substringBeforeLast((String)this.tolkExecutablePath, (String)"/") + "/smartcont_lib.zip";
                    File tmpFileSmartcont = new File(System.getProperty("user.dir") + "/smartcont/stdlib.fc");
                    if (!tmpFileSmartcont.exists()) {
                        String smartcontPath = Utils.getLocalOrDownload((String)smartcont);
                        ZipFile zipFile = new ZipFile(smartcontPath);
                        zipFile.extractAll(new File(smartcontPath).getParent());
                        Files.delete(Paths.get(smartcontPath, new String[0]));
                    }
                }
                catch (Exception e) {
                    log.error("cannot download smartcont_lib.zip");
                }
            }
            this.tolkExecutablePath = Utils.getLocalOrDownload((String)this.tolkExecutablePath);
            if (StringUtils.isEmpty((CharSequence)this.tolkStdLibPath)) {
                this.tolkStdLibPath = new File(this.tolkExecutablePath).getParent() + "/smartcont/tolk-stdlib";
            }
            if (this.printInfo.booleanValue()) {
                log.info("Using {}, TOLK_STDLIB={}", (Object)this.tolkExecutablePath, (Object)this.tolkStdLibPath);
            }
            tolkExecutable = this.tolkExecutablePath;
            return super.build();
        }

        private String getTolkSystemStdLibPath() {
            if (Utils.getOS() == Utils.OS.WINDOWS) {
                return "C:/ProgramData/chocolatey/lib/ton/bin/smartcont/tolk-stdlib";
            }
            if (Utils.getOS() == Utils.OS.MAC) {
                return "/opt/homebrew/share/ton/ton/smartcont/tolk-stdlib";
            }
            return "/usr/share/ton/smartcont/tolk-stdlib";
        }
    }

    public static class TolkRunnerBuilder {
        private String tolkExecutablePath;
        private String tolkStdLibPath;
        private Boolean printInfo;

        TolkRunnerBuilder() {
        }

        public TolkRunnerBuilder tolkExecutablePath(String tolkExecutablePath) {
            this.tolkExecutablePath = tolkExecutablePath;
            return this;
        }

        public TolkRunnerBuilder tolkStdLibPath(String tolkStdLibPath) {
            this.tolkStdLibPath = tolkStdLibPath;
            return this;
        }

        public TolkRunnerBuilder printInfo(Boolean printInfo) {
            this.printInfo = printInfo;
            return this;
        }

        public TolkRunner build() {
            return new TolkRunner(this.tolkExecutablePath, this.tolkStdLibPath, this.printInfo);
        }

        public String toString() {
            return "TolkRunner.TolkRunnerBuilder(tolkExecutablePath=" + this.tolkExecutablePath + ", tolkStdLibPath=" + this.tolkStdLibPath + ", printInfo=" + this.printInfo + ")";
        }
    }
}

