/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.WorkchainFormat;

public class WorkchainFormatBasic
implements WorkchainFormat,
Serializable {
    int wfmtBasic;
    long vmVersion;
    BigInteger vmMode;

    @Override
    public Cell toCell(boolean basic) {
        if (basic) {
            return CellBuilder.beginCell().storeUint(1, 4).storeUint(this.vmVersion, 32).storeUint(this.vmMode, 64).endCell();
        }
        return null;
    }

    public static WorkchainFormatBasic deserialize(CellSlice cs) {
        return WorkchainFormatBasic.builder().wfmtBasic(cs.loadUint(4).intValue()).vmVersion(cs.loadUint(32).longValue()).vmMode(cs.loadUint(64)).build();
    }

    WorkchainFormatBasic(int wfmtBasic, long vmVersion, BigInteger vmMode) {
        this.wfmtBasic = wfmtBasic;
        this.vmVersion = vmVersion;
        this.vmMode = vmMode;
    }

    public static WorkchainFormatBasicBuilder builder() {
        return new WorkchainFormatBasicBuilder();
    }

    public int getWfmtBasic() {
        return this.wfmtBasic;
    }

    public long getVmVersion() {
        return this.vmVersion;
    }

    public BigInteger getVmMode() {
        return this.vmMode;
    }

    public void setWfmtBasic(int wfmtBasic) {
        this.wfmtBasic = wfmtBasic;
    }

    public void setVmVersion(long vmVersion) {
        this.vmVersion = vmVersion;
    }

    public void setVmMode(BigInteger vmMode) {
        this.vmMode = vmMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkchainFormatBasic)) {
            return false;
        }
        WorkchainFormatBasic other = (WorkchainFormatBasic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWfmtBasic() != other.getWfmtBasic()) {
            return false;
        }
        if (this.getVmVersion() != other.getVmVersion()) {
            return false;
        }
        BigInteger this$vmMode = this.getVmMode();
        BigInteger other$vmMode = other.getVmMode();
        return !(this$vmMode == null ? other$vmMode != null : !((Object)this$vmMode).equals(other$vmMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkchainFormatBasic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWfmtBasic();
        long $vmVersion = this.getVmVersion();
        result = result * 59 + (int)($vmVersion >>> 32 ^ $vmVersion);
        BigInteger $vmMode = this.getVmMode();
        result = result * 59 + ($vmMode == null ? 43 : ((Object)$vmMode).hashCode());
        return result;
    }

    public String toString() {
        return "WorkchainFormatBasic(wfmtBasic=" + this.getWfmtBasic() + ", vmVersion=" + this.getVmVersion() + ", vmMode=" + String.valueOf(this.getVmMode()) + ")";
    }

    public static class WorkchainFormatBasicBuilder {
        private int wfmtBasic;
        private long vmVersion;
        private BigInteger vmMode;

        WorkchainFormatBasicBuilder() {
        }

        public WorkchainFormatBasicBuilder wfmtBasic(int wfmtBasic) {
            this.wfmtBasic = wfmtBasic;
            return this;
        }

        public WorkchainFormatBasicBuilder vmVersion(long vmVersion) {
            this.vmVersion = vmVersion;
            return this;
        }

        public WorkchainFormatBasicBuilder vmMode(BigInteger vmMode) {
            this.vmMode = vmMode;
            return this;
        }

        public WorkchainFormatBasic build() {
            return new WorkchainFormatBasic(this.wfmtBasic, this.vmVersion, this.vmMode);
        }

        public String toString() {
            return "WorkchainFormatBasic.WorkchainFormatBasicBuilder(wfmtBasic=" + this.wfmtBasic + ", vmVersion=" + this.vmVersion + ", vmMode=" + String.valueOf(this.vmMode) + ")";
        }
    }
}

