/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmCont;

public class VmcQuit
implements VmCont,
Serializable {
    long magic;
    long exitCode;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(8, 4).storeInt(this.exitCode, 32).endCell();
    }

    public static VmcQuit deserialize(CellSlice cs) {
        return VmcQuit.builder().magic(cs.loadUint(4).intValue()).exitCode(cs.loadInt(32).longValue()).build();
    }

    VmcQuit(long magic, long exitCode) {
        this.magic = magic;
        this.exitCode = exitCode;
    }

    public static VmcQuitBuilder builder() {
        return new VmcQuitBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public long getExitCode() {
        return this.exitCode;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setExitCode(long exitCode) {
        this.exitCode = exitCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmcQuit)) {
            return false;
        }
        VmcQuit other = (VmcQuit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        return this.getExitCode() == other.getExitCode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmcQuit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        long $exitCode = this.getExitCode();
        result = result * 59 + (int)($exitCode >>> 32 ^ $exitCode);
        return result;
    }

    public String toString() {
        return "VmcQuit(magic=" + this.getMagic() + ", exitCode=" + this.getExitCode() + ")";
    }

    public static class VmcQuitBuilder {
        private long magic;
        private long exitCode;

        VmcQuitBuilder() {
        }

        public VmcQuitBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public VmcQuitBuilder exitCode(long exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public VmcQuit build() {
            return new VmcQuit(this.magic, this.exitCode);
        }

        public String toString() {
            return "VmcQuit.VmcQuitBuilder(magic=" + this.magic + ", exitCode=" + this.exitCode + ")";
        }
    }
}

