/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmCellSlice;
import org.ton.java.tlb.VmStackValue;

public class VmStackValueSlice
implements VmStackValue,
Serializable {
    int magic;
    VmCellSlice cell;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(4, 8).storeCell(this.cell.toCell()).endCell();
    }

    public static VmStackValueSlice deserialize(CellSlice cs) {
        return VmStackValueSlice.builder().magic(cs.loadUint(8).intValue()).cell(VmCellSlice.deserialize(cs)).build();
    }

    VmStackValueSlice(int magic, VmCellSlice cell) {
        this.magic = magic;
        this.cell = cell;
    }

    public static VmStackValueSliceBuilder builder() {
        return new VmStackValueSliceBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public VmCellSlice getCell() {
        return this.cell;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setCell(VmCellSlice cell) {
        this.cell = cell;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmStackValueSlice)) {
            return false;
        }
        VmStackValueSlice other = (VmStackValueSlice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        VmCellSlice this$cell = this.getCell();
        VmCellSlice other$cell = other.getCell();
        return !(this$cell == null ? other$cell != null : !((Object)this$cell).equals(other$cell));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmStackValueSlice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        VmCellSlice $cell = this.getCell();
        result = result * 59 + ($cell == null ? 43 : ((Object)$cell).hashCode());
        return result;
    }

    public String toString() {
        return "VmStackValueSlice(magic=" + this.getMagic() + ", cell=" + String.valueOf(this.getCell()) + ")";
    }

    public static class VmStackValueSliceBuilder {
        private int magic;
        private VmCellSlice cell;

        VmStackValueSliceBuilder() {
        }

        public VmStackValueSliceBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public VmStackValueSliceBuilder cell(VmCellSlice cell) {
            this.cell = cell;
            return this;
        }

        public VmStackValueSlice build() {
            return new VmStackValueSlice(this.magic, this.cell);
        }

        public String toString() {
            return "VmStackValueSlice.VmStackValueSliceBuilder(magic=" + this.magic + ", cell=" + String.valueOf(this.cell) + ")";
        }
    }
}

