/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmStackValue;

public class VmStackValueInt
implements VmStackValue,
Serializable {
    long magic;
    BigInteger value;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(256, 15).storeInt(this.value, 257).endCell();
    }

    public static VmStackValueInt deserialize(CellSlice cs) {
        return VmStackValueInt.builder().magic(cs.loadUint(15).intValue()).value(cs.loadInt(257)).build();
    }

    VmStackValueInt(long magic, BigInteger value) {
        this.magic = magic;
        this.value = value;
    }

    public static VmStackValueIntBuilder builder() {
        return new VmStackValueIntBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmStackValueInt)) {
            return false;
        }
        VmStackValueInt other = (VmStackValueInt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmStackValueInt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public String toString() {
        return "VmStackValueInt(magic=" + this.getMagic() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    public static class VmStackValueIntBuilder {
        private long magic;
        private BigInteger value;

        VmStackValueIntBuilder() {
        }

        public VmStackValueIntBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public VmStackValueIntBuilder value(BigInteger value) {
            this.value = value;
            return this;
        }

        public VmStackValueInt build() {
            return new VmStackValueInt(this.magic, this.value);
        }

        public String toString() {
            return "VmStackValueInt.VmStackValueIntBuilder(magic=" + this.magic + ", value=" + String.valueOf(this.value) + ")";
        }
    }
}

