/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmStackValue;

public class VmStackValueBuilder
implements VmStackValue,
Serializable {
    int magic;
    Cell cell;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(5, 8).storeRef(this.cell).endCell();
    }

    public static VmStackValueBuilder deserialize(CellSlice cs) {
        return VmStackValueBuilder.builder().magic(cs.loadUint(8).intValue()).cell(cs.loadRef()).build();
    }

    VmStackValueBuilder(int magic, Cell cell) {
        this.magic = magic;
        this.cell = cell;
    }

    public static VmStackValueBuilderBuilder builder() {
        return new VmStackValueBuilderBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmStackValueBuilder)) {
            return false;
        }
        VmStackValueBuilder other = (VmStackValueBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        Cell this$cell = this.getCell();
        Cell other$cell = other.getCell();
        return !(this$cell == null ? other$cell != null : !this$cell.equals(other$cell));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmStackValueBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        Cell $cell = this.getCell();
        result = result * 59 + ($cell == null ? 43 : $cell.hashCode());
        return result;
    }

    public String toString() {
        return "VmStackValueBuilder(magic=" + this.getMagic() + ", cell=" + String.valueOf(this.getCell()) + ")";
    }

    public static class VmStackValueBuilderBuilder {
        private int magic;
        private Cell cell;

        VmStackValueBuilderBuilder() {
        }

        public VmStackValueBuilderBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public VmStackValueBuilderBuilder cell(Cell cell) {
            this.cell = cell;
            return this;
        }

        public VmStackValueBuilder build() {
            return new VmStackValueBuilder(this.magic, this.cell);
        }

        public String toString() {
            return "VmStackValueBuilder.VmStackValueBuilderBuilder(magic=" + this.magic + ", cell=" + String.valueOf(this.cell) + ")";
        }
    }
}

