/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmStackValue;

public class VmStackList
implements Serializable {
    List<VmStackValue> tos;

    public Cell toCell() {
        Cell list = CellBuilder.beginCell().endCell();
        for (VmStackValue value : this.tos) {
            Cell valueCell = value.toCell();
            list = CellBuilder.beginCell().storeRef(list).storeCell(valueCell).endCell();
        }
        return list;
    }

    public static VmStackList deserialize(CellSlice cs, int depth) {
        if (depth == 0) {
            return VmStackList.builder().tos(Collections.emptyList()).build();
        }
        ArrayList<VmStackValue> ar1 = new ArrayList<VmStackValue>(VmStackList.deserialize(CellSlice.beginParse((Cell)cs.loadRef()), depth - 1).getTos());
        ar1.add(VmStackValue.deserialize(cs));
        return VmStackList.builder().tos(ar1).build();
    }

    VmStackList(List<VmStackValue> tos) {
        this.tos = tos;
    }

    public static VmStackListBuilder builder() {
        return new VmStackListBuilder();
    }

    public List<VmStackValue> getTos() {
        return this.tos;
    }

    public void setTos(List<VmStackValue> tos) {
        this.tos = tos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmStackList)) {
            return false;
        }
        VmStackList other = (VmStackList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<VmStackValue> this$tos = this.getTos();
        List<VmStackValue> other$tos = other.getTos();
        return !(this$tos == null ? other$tos != null : !((Object)this$tos).equals(other$tos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmStackList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<VmStackValue> $tos = this.getTos();
        result = result * 59 + ($tos == null ? 43 : ((Object)$tos).hashCode());
        return result;
    }

    public String toString() {
        return "VmStackList(tos=" + String.valueOf(this.getTos()) + ")";
    }

    public static class VmStackListBuilder {
        private List<VmStackValue> tos;

        VmStackListBuilder() {
        }

        public VmStackListBuilder tos(List<VmStackValue> tos) {
            this.tos = tos;
            return this;
        }

        public VmStackList build() {
            return new VmStackList(this.tos);
        }

        public String toString() {
            return "VmStackList.VmStackListBuilder(tos=" + String.valueOf(this.tos) + ")";
        }
    }
}

