/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.VmStackList;

public class VmStack
implements Serializable {
    int depth;
    VmStackList stack;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.depth, 24).storeCell(this.stack.toCell()).endCell();
    }

    public static VmStack deserialize(CellSlice cs) {
        int depth = cs.loadUint(24).intValue();
        return VmStack.builder().depth(depth).stack(VmStackList.deserialize(cs, depth)).build();
    }

    VmStack(int depth, VmStackList stack) {
        this.depth = depth;
        this.stack = stack;
    }

    public static VmStackBuilder builder() {
        return new VmStackBuilder();
    }

    public int getDepth() {
        return this.depth;
    }

    public VmStackList getStack() {
        return this.stack;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setStack(VmStackList stack) {
        this.stack = stack;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmStack)) {
            return false;
        }
        VmStack other = (VmStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        VmStackList this$stack = this.getStack();
        VmStackList other$stack = other.getStack();
        return !(this$stack == null ? other$stack != null : !((Object)this$stack).equals(other$stack));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VmStack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDepth();
        VmStackList $stack = this.getStack();
        result = result * 59 + ($stack == null ? 43 : ((Object)$stack).hashCode());
        return result;
    }

    public String toString() {
        return "VmStack(depth=" + this.getDepth() + ", stack=" + String.valueOf(this.getStack()) + ")";
    }

    public static class VmStackBuilder {
        private int depth;
        private VmStackList stack;

        VmStackBuilder() {
        }

        public VmStackBuilder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public VmStackBuilder stack(VmStackList stack) {
            this.stack = stack;
            return this;
        }

        public VmStack build() {
            return new VmStack(this.depth, this.stack);
        }

        public String toString() {
            return "VmStack.VmStackBuilder(depth=" + this.depth + ", stack=" + String.valueOf(this.stack) + ")";
        }
    }
}

