/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.SigPubKey;

public class ValidatorTempKey
implements Serializable {
    int magic;
    BigInteger adnlAddr;
    SigPubKey tempPublicKey;
    long seqno;
    long validUntil;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(3, 4).storeUint(this.adnlAddr, 256).storeCell(this.tempPublicKey.toCell()).storeUint(this.seqno, 32).storeUint(this.validUntil, 32).endCell();
    }

    public static ValidatorTempKey deserialize(CellSlice cs) {
        return ValidatorTempKey.builder().magic(cs.loadUint(4).intValue()).adnlAddr(cs.loadUint(256)).tempPublicKey(SigPubKey.deserialize(cs)).seqno(cs.loadUint(32).longValue()).validUntil(cs.loadUint(32).longValue()).build();
    }

    ValidatorTempKey(int magic, BigInteger adnlAddr, SigPubKey tempPublicKey, long seqno, long validUntil) {
        this.magic = magic;
        this.adnlAddr = adnlAddr;
        this.tempPublicKey = tempPublicKey;
        this.seqno = seqno;
        this.validUntil = validUntil;
    }

    public static ValidatorTempKeyBuilder builder() {
        return new ValidatorTempKeyBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public BigInteger getAdnlAddr() {
        return this.adnlAddr;
    }

    public SigPubKey getTempPublicKey() {
        return this.tempPublicKey;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public long getValidUntil() {
        return this.validUntil;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setAdnlAddr(BigInteger adnlAddr) {
        this.adnlAddr = adnlAddr;
    }

    public void setTempPublicKey(SigPubKey tempPublicKey) {
        this.tempPublicKey = tempPublicKey;
    }

    public void setSeqno(long seqno) {
        this.seqno = seqno;
    }

    public void setValidUntil(long validUntil) {
        this.validUntil = validUntil;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidatorTempKey)) {
            return false;
        }
        ValidatorTempKey other = (ValidatorTempKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getSeqno() != other.getSeqno()) {
            return false;
        }
        if (this.getValidUntil() != other.getValidUntil()) {
            return false;
        }
        BigInteger this$adnlAddr = this.getAdnlAddr();
        BigInteger other$adnlAddr = other.getAdnlAddr();
        if (this$adnlAddr == null ? other$adnlAddr != null : !((Object)this$adnlAddr).equals(other$adnlAddr)) {
            return false;
        }
        SigPubKey this$tempPublicKey = this.getTempPublicKey();
        SigPubKey other$tempPublicKey = other.getTempPublicKey();
        return !(this$tempPublicKey == null ? other$tempPublicKey != null : !((Object)this$tempPublicKey).equals(other$tempPublicKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidatorTempKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        long $seqno = this.getSeqno();
        result = result * 59 + (int)($seqno >>> 32 ^ $seqno);
        long $validUntil = this.getValidUntil();
        result = result * 59 + (int)($validUntil >>> 32 ^ $validUntil);
        BigInteger $adnlAddr = this.getAdnlAddr();
        result = result * 59 + ($adnlAddr == null ? 43 : ((Object)$adnlAddr).hashCode());
        SigPubKey $tempPublicKey = this.getTempPublicKey();
        result = result * 59 + ($tempPublicKey == null ? 43 : ((Object)$tempPublicKey).hashCode());
        return result;
    }

    public String toString() {
        return "ValidatorTempKey(magic=" + this.getMagic() + ", adnlAddr=" + String.valueOf(this.getAdnlAddr()) + ", tempPublicKey=" + String.valueOf(this.getTempPublicKey()) + ", seqno=" + this.getSeqno() + ", validUntil=" + this.getValidUntil() + ")";
    }

    public static class ValidatorTempKeyBuilder {
        private int magic;
        private BigInteger adnlAddr;
        private SigPubKey tempPublicKey;
        private long seqno;
        private long validUntil;

        ValidatorTempKeyBuilder() {
        }

        public ValidatorTempKeyBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ValidatorTempKeyBuilder adnlAddr(BigInteger adnlAddr) {
            this.adnlAddr = adnlAddr;
            return this;
        }

        public ValidatorTempKeyBuilder tempPublicKey(SigPubKey tempPublicKey) {
            this.tempPublicKey = tempPublicKey;
            return this;
        }

        public ValidatorTempKeyBuilder seqno(long seqno) {
            this.seqno = seqno;
            return this;
        }

        public ValidatorTempKeyBuilder validUntil(long validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public ValidatorTempKey build() {
            return new ValidatorTempKey(this.magic, this.adnlAddr, this.tempPublicKey, this.seqno, this.validUntil);
        }

        public String toString() {
            return "ValidatorTempKey.ValidatorTempKeyBuilder(magic=" + this.magic + ", adnlAddr=" + String.valueOf(this.adnlAddr) + ", tempPublicKey=" + String.valueOf(this.tempPublicKey) + ", seqno=" + this.seqno + ", validUntil=" + this.validUntil + ")";
        }
    }
}

