/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.SigPubKey;
import org.ton.java.tlb.ValidatorDescr;

public class ValidatorAddr
implements ValidatorDescr,
Serializable {
    int magic;
    SigPubKey publicKey;
    BigInteger weight;
    BigInteger adnlAddr;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(115, 8).storeCell(this.publicKey.toCell()).storeUint(this.weight, 64).storeUint(this.adnlAddr, 256).endCell();
    }

    public static ValidatorAddr deserialize(CellSlice cs) {
        return ValidatorAddr.builder().magic(cs.loadUint(8).intValue()).publicKey(SigPubKey.deserialize(cs)).weight(cs.loadUint(64)).adnlAddr(cs.loadUint(256)).build();
    }

    @Override
    public String getPublicKeyHex() {
        return this.publicKey.getPubkey().toString(16);
    }

    @Override
    public String getAdnlAddressHex() {
        return Objects.nonNull(this.adnlAddr) ? this.adnlAddr.toString(16) : "";
    }

    ValidatorAddr(int magic, SigPubKey publicKey, BigInteger weight, BigInteger adnlAddr) {
        this.magic = magic;
        this.publicKey = publicKey;
        this.weight = weight;
        this.adnlAddr = adnlAddr;
    }

    public static ValidatorAddrBuilder builder() {
        return new ValidatorAddrBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public SigPubKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public BigInteger getWeight() {
        return this.weight;
    }

    public BigInteger getAdnlAddr() {
        return this.adnlAddr;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setPublicKey(SigPubKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setWeight(BigInteger weight) {
        this.weight = weight;
    }

    public void setAdnlAddr(BigInteger adnlAddr) {
        this.adnlAddr = adnlAddr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidatorAddr)) {
            return false;
        }
        ValidatorAddr other = (ValidatorAddr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        SigPubKey this$publicKey = this.getPublicKey();
        SigPubKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey)) {
            return false;
        }
        BigInteger this$weight = this.getWeight();
        BigInteger other$weight = other.getWeight();
        if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
            return false;
        }
        BigInteger this$adnlAddr = this.getAdnlAddr();
        BigInteger other$adnlAddr = other.getAdnlAddr();
        return !(this$adnlAddr == null ? other$adnlAddr != null : !((Object)this$adnlAddr).equals(other$adnlAddr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidatorAddr;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        SigPubKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
        BigInteger $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        BigInteger $adnlAddr = this.getAdnlAddr();
        result = result * 59 + ($adnlAddr == null ? 43 : ((Object)$adnlAddr).hashCode());
        return result;
    }

    public String toString() {
        return "ValidatorAddr(magic=" + this.getMagic() + ", publicKey=" + String.valueOf(this.getPublicKey()) + ", weight=" + String.valueOf(this.getWeight()) + ", adnlAddr=" + String.valueOf(this.getAdnlAddr()) + ")";
    }

    public static class ValidatorAddrBuilder {
        private int magic;
        private SigPubKey publicKey;
        private BigInteger weight;
        private BigInteger adnlAddr;

        ValidatorAddrBuilder() {
        }

        public ValidatorAddrBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ValidatorAddrBuilder publicKey(SigPubKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public ValidatorAddrBuilder weight(BigInteger weight) {
            this.weight = weight;
            return this;
        }

        public ValidatorAddrBuilder adnlAddr(BigInteger adnlAddr) {
            this.adnlAddr = adnlAddr;
            return this;
        }

        public ValidatorAddr build() {
            return new ValidatorAddr(this.magic, this.publicKey, this.weight, this.adnlAddr);
        }

        public String toString() {
            return "ValidatorAddr.ValidatorAddrBuilder(magic=" + this.magic + ", publicKey=" + String.valueOf(this.publicKey) + ", weight=" + String.valueOf(this.weight) + ", adnlAddr=" + String.valueOf(this.adnlAddr) + ")";
        }
    }
}

