/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.StoragePhase;
import org.ton.java.tlb.TransactionDescription;

public class TransactionDescriptionStorage
implements TransactionDescription,
Serializable {
    int magic;
    StoragePhase storagePhase;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 4).storeCell(this.storagePhase.toCell()).endCell();
    }

    public static TransactionDescriptionStorage deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).intValue();
        assert (magic == 1L) : "TransactionDescriptionStorage: magic not equal to 0b0001, found 0x" + Long.toHexString(magic);
        return TransactionDescriptionStorage.builder().magic(1).storagePhase(StoragePhase.deserialize(cs)).build();
    }

    @Override
    public String getType() {
        return "storage";
    }

    TransactionDescriptionStorage(int magic, StoragePhase storagePhase) {
        this.magic = magic;
        this.storagePhase = storagePhase;
    }

    public static TransactionDescriptionStorageBuilder builder() {
        return new TransactionDescriptionStorageBuilder();
    }

    public StoragePhase getStoragePhase() {
        return this.storagePhase;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setStoragePhase(StoragePhase storagePhase) {
        this.storagePhase = storagePhase;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDescriptionStorage)) {
            return false;
        }
        TransactionDescriptionStorage other = (TransactionDescriptionStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        StoragePhase this$storagePhase = this.getStoragePhase();
        StoragePhase other$storagePhase = other.getStoragePhase();
        return !(this$storagePhase == null ? other$storagePhase != null : !((Object)this$storagePhase).equals(other$storagePhase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDescriptionStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        StoragePhase $storagePhase = this.getStoragePhase();
        result = result * 59 + ($storagePhase == null ? 43 : ((Object)$storagePhase).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionDescriptionStorage(magic=" + this.getMagic() + ", storagePhase=" + String.valueOf(this.getStoragePhase()) + ")";
    }

    public static class TransactionDescriptionStorageBuilder {
        private int magic;
        private StoragePhase storagePhase;

        TransactionDescriptionStorageBuilder() {
        }

        public TransactionDescriptionStorageBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public TransactionDescriptionStorageBuilder storagePhase(StoragePhase storagePhase) {
            this.storagePhase = storagePhase;
            return this;
        }

        public TransactionDescriptionStorage build() {
            return new TransactionDescriptionStorage(this.magic, this.storagePhase);
        }

        public String toString() {
            return "TransactionDescriptionStorage.TransactionDescriptionStorageBuilder(magic=" + this.magic + ", storagePhase=" + String.valueOf(this.storagePhase) + ")";
        }
    }
}

