/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ActionPhase;
import org.ton.java.tlb.BouncePhase;
import org.ton.java.tlb.ComputePhase;
import org.ton.java.tlb.CreditPhase;
import org.ton.java.tlb.StoragePhase;
import org.ton.java.tlb.TransactionDescription;

public class TransactionDescriptionOrdinary
implements TransactionDescription,
Serializable {
    int magic;
    boolean creditFirst;
    StoragePhase storagePhase;
    CreditPhase creditPhase;
    ComputePhase computePhase;
    ActionPhase actionPhase;
    boolean aborted;
    BouncePhase bouncePhase;
    boolean destroyed;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(0, 4).storeBit(Boolean.valueOf(this.creditFirst)).storeCellMaybe(Objects.nonNull(this.storagePhase) ? this.storagePhase.toCell() : null).storeCellMaybe(Objects.nonNull(this.creditPhase) ? this.creditPhase.toCell() : null).storeCell(this.computePhase.toCell()).storeRefMaybe(Objects.nonNull(this.actionPhase) ? this.actionPhase.toCell() : null).storeBit(Boolean.valueOf(this.aborted)).storeCellMaybe(Objects.nonNull(this.bouncePhase) ? this.bouncePhase.toCell() : null).storeBit(Boolean.valueOf(this.destroyed)).endCell();
    }

    public static TransactionDescriptionOrdinary deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).intValue();
        assert (magic == 0L) : "TransactionDescriptionOrdinary: magic not equal to 0b0000, found 0x" + Long.toHexString(magic);
        return TransactionDescriptionOrdinary.builder().magic(0).creditFirst(cs.loadBit()).storagePhase(cs.loadBit() ? StoragePhase.deserialize(cs) : null).creditPhase(cs.loadBit() ? CreditPhase.deserialize(cs) : null).computePhase(ComputePhase.deserialize(cs)).actionPhase(cs.loadBit() ? ActionPhase.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null).aborted(cs.loadBit()).bouncePhase(cs.loadBit() ? BouncePhase.deserialize(cs) : null).destroyed(cs.loadBit()).build();
    }

    @Override
    public String getType() {
        return "ordinary";
    }

    TransactionDescriptionOrdinary(int magic, boolean creditFirst, StoragePhase storagePhase, CreditPhase creditPhase, ComputePhase computePhase, ActionPhase actionPhase, boolean aborted, BouncePhase bouncePhase, boolean destroyed) {
        this.magic = magic;
        this.creditFirst = creditFirst;
        this.storagePhase = storagePhase;
        this.creditPhase = creditPhase;
        this.computePhase = computePhase;
        this.actionPhase = actionPhase;
        this.aborted = aborted;
        this.bouncePhase = bouncePhase;
        this.destroyed = destroyed;
    }

    public static TransactionDescriptionOrdinaryBuilder builder() {
        return new TransactionDescriptionOrdinaryBuilder();
    }

    public boolean isCreditFirst() {
        return this.creditFirst;
    }

    public StoragePhase getStoragePhase() {
        return this.storagePhase;
    }

    public CreditPhase getCreditPhase() {
        return this.creditPhase;
    }

    public ComputePhase getComputePhase() {
        return this.computePhase;
    }

    public ActionPhase getActionPhase() {
        return this.actionPhase;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public BouncePhase getBouncePhase() {
        return this.bouncePhase;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setCreditFirst(boolean creditFirst) {
        this.creditFirst = creditFirst;
    }

    public void setStoragePhase(StoragePhase storagePhase) {
        this.storagePhase = storagePhase;
    }

    public void setCreditPhase(CreditPhase creditPhase) {
        this.creditPhase = creditPhase;
    }

    public void setComputePhase(ComputePhase computePhase) {
        this.computePhase = computePhase;
    }

    public void setActionPhase(ActionPhase actionPhase) {
        this.actionPhase = actionPhase;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public void setBouncePhase(BouncePhase bouncePhase) {
        this.bouncePhase = bouncePhase;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDescriptionOrdinary)) {
            return false;
        }
        TransactionDescriptionOrdinary other = (TransactionDescriptionOrdinary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.isCreditFirst() != other.isCreditFirst()) {
            return false;
        }
        if (this.isAborted() != other.isAborted()) {
            return false;
        }
        if (this.isDestroyed() != other.isDestroyed()) {
            return false;
        }
        StoragePhase this$storagePhase = this.getStoragePhase();
        StoragePhase other$storagePhase = other.getStoragePhase();
        if (this$storagePhase == null ? other$storagePhase != null : !((Object)this$storagePhase).equals(other$storagePhase)) {
            return false;
        }
        CreditPhase this$creditPhase = this.getCreditPhase();
        CreditPhase other$creditPhase = other.getCreditPhase();
        if (this$creditPhase == null ? other$creditPhase != null : !((Object)this$creditPhase).equals(other$creditPhase)) {
            return false;
        }
        ComputePhase this$computePhase = this.getComputePhase();
        ComputePhase other$computePhase = other.getComputePhase();
        if (this$computePhase == null ? other$computePhase != null : !this$computePhase.equals(other$computePhase)) {
            return false;
        }
        ActionPhase this$actionPhase = this.getActionPhase();
        ActionPhase other$actionPhase = other.getActionPhase();
        if (this$actionPhase == null ? other$actionPhase != null : !((Object)this$actionPhase).equals(other$actionPhase)) {
            return false;
        }
        BouncePhase this$bouncePhase = this.getBouncePhase();
        BouncePhase other$bouncePhase = other.getBouncePhase();
        return !(this$bouncePhase == null ? other$bouncePhase != null : !this$bouncePhase.equals(other$bouncePhase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDescriptionOrdinary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + (this.isCreditFirst() ? 79 : 97);
        result = result * 59 + (this.isAborted() ? 79 : 97);
        result = result * 59 + (this.isDestroyed() ? 79 : 97);
        StoragePhase $storagePhase = this.getStoragePhase();
        result = result * 59 + ($storagePhase == null ? 43 : ((Object)$storagePhase).hashCode());
        CreditPhase $creditPhase = this.getCreditPhase();
        result = result * 59 + ($creditPhase == null ? 43 : ((Object)$creditPhase).hashCode());
        ComputePhase $computePhase = this.getComputePhase();
        result = result * 59 + ($computePhase == null ? 43 : $computePhase.hashCode());
        ActionPhase $actionPhase = this.getActionPhase();
        result = result * 59 + ($actionPhase == null ? 43 : ((Object)$actionPhase).hashCode());
        BouncePhase $bouncePhase = this.getBouncePhase();
        result = result * 59 + ($bouncePhase == null ? 43 : $bouncePhase.hashCode());
        return result;
    }

    public String toString() {
        return "TransactionDescriptionOrdinary(magic=" + this.getMagic() + ", creditFirst=" + this.isCreditFirst() + ", storagePhase=" + String.valueOf(this.getStoragePhase()) + ", creditPhase=" + String.valueOf(this.getCreditPhase()) + ", computePhase=" + String.valueOf(this.getComputePhase()) + ", actionPhase=" + String.valueOf(this.getActionPhase()) + ", aborted=" + this.isAborted() + ", bouncePhase=" + String.valueOf(this.getBouncePhase()) + ", destroyed=" + this.isDestroyed() + ")";
    }

    public static class TransactionDescriptionOrdinaryBuilder {
        private int magic;
        private boolean creditFirst;
        private StoragePhase storagePhase;
        private CreditPhase creditPhase;
        private ComputePhase computePhase;
        private ActionPhase actionPhase;
        private boolean aborted;
        private BouncePhase bouncePhase;
        private boolean destroyed;

        TransactionDescriptionOrdinaryBuilder() {
        }

        public TransactionDescriptionOrdinaryBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public TransactionDescriptionOrdinaryBuilder creditFirst(boolean creditFirst) {
            this.creditFirst = creditFirst;
            return this;
        }

        public TransactionDescriptionOrdinaryBuilder storagePhase(StoragePhase storagePhase) {
            this.storagePhase = storagePhase;
            return this;
        }

        public TransactionDescriptionOrdinaryBuilder creditPhase(CreditPhase creditPhase) {
            this.creditPhase = creditPhase;
            return this;
        }

        public TransactionDescriptionOrdinaryBuilder computePhase(ComputePhase computePhase) {
            this.computePhase = computePhase;
            return this;
        }

        public TransactionDescriptionOrdinaryBuilder actionPhase(ActionPhase actionPhase) {
            this.actionPhase = actionPhase;
            return this;
        }

        public TransactionDescriptionOrdinaryBuilder aborted(boolean aborted) {
            this.aborted = aborted;
            return this;
        }

        public TransactionDescriptionOrdinaryBuilder bouncePhase(BouncePhase bouncePhase) {
            this.bouncePhase = bouncePhase;
            return this;
        }

        public TransactionDescriptionOrdinaryBuilder destroyed(boolean destroyed) {
            this.destroyed = destroyed;
            return this;
        }

        public TransactionDescriptionOrdinary build() {
            return new TransactionDescriptionOrdinary(this.magic, this.creditFirst, this.storagePhase, this.creditPhase, this.computePhase, this.actionPhase, this.aborted, this.bouncePhase, this.destroyed);
        }

        public String toString() {
            return "TransactionDescriptionOrdinary.TransactionDescriptionOrdinaryBuilder(magic=" + this.magic + ", creditFirst=" + this.creditFirst + ", storagePhase=" + String.valueOf(this.storagePhase) + ", creditPhase=" + String.valueOf(this.creditPhase) + ", computePhase=" + String.valueOf(this.computePhase) + ", actionPhase=" + String.valueOf(this.actionPhase) + ", aborted=" + this.aborted + ", bouncePhase=" + String.valueOf(this.bouncePhase) + ", destroyed=" + this.destroyed + ")";
        }
    }
}

