/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.AccountStates;
import org.ton.java.tlb.BouncePhase;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.HashUpdate;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.TransactionDescription;
import org.ton.java.tlb.TransactionDescriptionOrdinary;
import org.ton.java.tlb.TransactionIO;

public class Transaction
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Transaction.class);
    int magic;
    BigInteger accountAddr;
    BigInteger lt;
    BigInteger prevTxHash;
    BigInteger prevTxLt;
    long now;
    long outMsgCount;
    AccountStates origStatus;
    AccountStates endStatus;
    TransactionIO inOut;
    CurrencyCollection totalFees;
    HashUpdate stateUpdate;
    TransactionDescription description;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    public String getAccountAddrShort() {
        if (Objects.nonNull(this.accountAddr)) {
            String str64 = StringUtils.leftPad((String)this.accountAddr.toString(16), (int)64, (String)"0");
            return str64.substring(0, 5) + "..." + str64.substring(str64.length() - 5);
        }
        return "N/A";
    }

    public String getAccountAddr() {
        if (Objects.nonNull(this.accountAddr)) {
            return StringUtils.leftPad((String)this.accountAddr.toString(16), (int)64, (String)"0");
        }
        return "";
    }

    public String getPrevTxHash() {
        if (Objects.nonNull(this.accountAddr)) {
            return StringUtils.leftPad((String)this.prevTxHash.toString(16), (int)64, (String)"0").toUpperCase();
        }
        return "";
    }

    public Cell toCell() {
        CellBuilder c = CellBuilder.beginCell();
        c.storeUint(7, 4);
        c.storeUint(this.accountAddr, 256);
        c.storeUint(this.lt, 64);
        c.storeUint(this.prevTxHash, 256);
        c.storeUint(this.prevTxLt, 64);
        c.storeUint(this.now, 32);
        c.storeUint(this.outMsgCount, 15);
        c.storeCell(Transaction.serializeAccountState(this.origStatus));
        c.storeCell(Transaction.serializeAccountState(this.endStatus));
        c.storeCell(this.totalFees.toCell());
        c.storeRef(this.inOut.toCell());
        c.storeRef(this.stateUpdate.toCell());
        c.storeRef(this.description.toCell());
        return c.endCell();
    }

    public static Transaction deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).intValue();
        assert (magic == 7L) : "Transaction: magic not equal to 0b0111, found 0b" + Long.toBinaryString(magic);
        Transaction tx = Transaction.builder().magic(7).accountAddr(cs.loadUint(256)).lt(cs.loadUint(64)).prevTxHash(cs.loadUint(256)).prevTxLt(cs.loadUint(64)).now(cs.loadUint(32).longValue()).outMsgCount(cs.loadUint(15).intValue()).origStatus(Transaction.deserializeAccountState(cs.loadUint(2).byteValue())).endStatus(Transaction.deserializeAccountState(cs.loadUint(2).byteValueExact())).build();
        CellSlice inOutMsgs = CellSlice.beginParse((Cell)cs.loadRef());
        Message msg = inOutMsgs.loadBit() ? Message.deserialize(CellSlice.beginParse((Cell)inOutMsgs.loadRef())) : null;
        TonHashMapE out = inOutMsgs.loadDictE(15, k -> k.readUint(15), v -> Message.deserialize(CellSlice.beginParse((Cell)CellSlice.beginParse((Cell)v).loadRef())));
        tx.setInOut(TransactionIO.builder().in(msg).out(out).build());
        tx.setTotalFees(CurrencyCollection.deserialize(cs));
        tx.setStateUpdate(HashUpdate.deserialize(CellSlice.beginParse((Cell)cs.loadRef())));
        tx.setDescription(TransactionDescription.deserialize(CellSlice.beginParse((Cell)cs.loadRef())));
        return tx;
    }

    public static Cell serializeAccountState(AccountStates state) {
        switch (state) {
            case UNINIT: {
                return CellBuilder.beginCell().storeUint(0, 2).endCell();
            }
            case FROZEN: {
                return CellBuilder.beginCell().storeUint(1, 2).endCell();
            }
            case ACTIVE: {
                return CellBuilder.beginCell().storeUint(2, 2).endCell();
            }
            case NON_EXIST: {
                return CellBuilder.beginCell().storeUint(3, 2).endCell();
            }
        }
        return null;
    }

    public static AccountStates deserializeAccountState(byte state) {
        switch (state) {
            case 0: {
                return AccountStates.UNINIT;
            }
            case 1: {
                return AccountStates.FROZEN;
            }
            case 2: {
                return AccountStates.ACTIVE;
            }
            case 3: {
                return AccountStates.NON_EXIST;
            }
        }
        return null;
    }

    public TransactionDescriptionOrdinary getOrdinaryTransaction() {
        return (TransactionDescriptionOrdinary)this.getDescription();
    }

    public BouncePhase getBouncePhase() {
        return ((TransactionDescriptionOrdinary)this.getDescription()).getBouncePhase();
    }

    Transaction(int magic, BigInteger accountAddr, BigInteger lt, BigInteger prevTxHash, BigInteger prevTxLt, long now, long outMsgCount, AccountStates origStatus, AccountStates endStatus, TransactionIO inOut, CurrencyCollection totalFees, HashUpdate stateUpdate, TransactionDescription description) {
        this.magic = magic;
        this.accountAddr = accountAddr;
        this.lt = lt;
        this.prevTxHash = prevTxHash;
        this.prevTxLt = prevTxLt;
        this.now = now;
        this.outMsgCount = outMsgCount;
        this.origStatus = origStatus;
        this.endStatus = endStatus;
        this.inOut = inOut;
        this.totalFees = totalFees;
        this.stateUpdate = stateUpdate;
        this.description = description;
    }

    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    public BigInteger getLt() {
        return this.lt;
    }

    public BigInteger getPrevTxLt() {
        return this.prevTxLt;
    }

    public long getNow() {
        return this.now;
    }

    public long getOutMsgCount() {
        return this.outMsgCount;
    }

    public AccountStates getOrigStatus() {
        return this.origStatus;
    }

    public AccountStates getEndStatus() {
        return this.endStatus;
    }

    public TransactionIO getInOut() {
        return this.inOut;
    }

    public CurrencyCollection getTotalFees() {
        return this.totalFees;
    }

    public HashUpdate getStateUpdate() {
        return this.stateUpdate;
    }

    public TransactionDescription getDescription() {
        return this.description;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setAccountAddr(BigInteger accountAddr) {
        this.accountAddr = accountAddr;
    }

    public void setLt(BigInteger lt) {
        this.lt = lt;
    }

    public void setPrevTxHash(BigInteger prevTxHash) {
        this.prevTxHash = prevTxHash;
    }

    public void setPrevTxLt(BigInteger prevTxLt) {
        this.prevTxLt = prevTxLt;
    }

    public void setNow(long now) {
        this.now = now;
    }

    public void setOutMsgCount(long outMsgCount) {
        this.outMsgCount = outMsgCount;
    }

    public void setOrigStatus(AccountStates origStatus) {
        this.origStatus = origStatus;
    }

    public void setEndStatus(AccountStates endStatus) {
        this.endStatus = endStatus;
    }

    public void setInOut(TransactionIO inOut) {
        this.inOut = inOut;
    }

    public void setTotalFees(CurrencyCollection totalFees) {
        this.totalFees = totalFees;
    }

    public void setStateUpdate(HashUpdate stateUpdate) {
        this.stateUpdate = stateUpdate;
    }

    public void setDescription(TransactionDescription description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getNow() != other.getNow()) {
            return false;
        }
        if (this.getOutMsgCount() != other.getOutMsgCount()) {
            return false;
        }
        String this$accountAddr = this.getAccountAddr();
        String other$accountAddr = other.getAccountAddr();
        if (this$accountAddr == null ? other$accountAddr != null : !this$accountAddr.equals(other$accountAddr)) {
            return false;
        }
        BigInteger this$lt = this.getLt();
        BigInteger other$lt = other.getLt();
        if (this$lt == null ? other$lt != null : !((Object)this$lt).equals(other$lt)) {
            return false;
        }
        String this$prevTxHash = this.getPrevTxHash();
        String other$prevTxHash = other.getPrevTxHash();
        if (this$prevTxHash == null ? other$prevTxHash != null : !this$prevTxHash.equals(other$prevTxHash)) {
            return false;
        }
        BigInteger this$prevTxLt = this.getPrevTxLt();
        BigInteger other$prevTxLt = other.getPrevTxLt();
        if (this$prevTxLt == null ? other$prevTxLt != null : !((Object)this$prevTxLt).equals(other$prevTxLt)) {
            return false;
        }
        AccountStates this$origStatus = this.getOrigStatus();
        AccountStates other$origStatus = other.getOrigStatus();
        if (this$origStatus == null ? other$origStatus != null : !((Object)((Object)this$origStatus)).equals((Object)other$origStatus)) {
            return false;
        }
        AccountStates this$endStatus = this.getEndStatus();
        AccountStates other$endStatus = other.getEndStatus();
        if (this$endStatus == null ? other$endStatus != null : !((Object)((Object)this$endStatus)).equals((Object)other$endStatus)) {
            return false;
        }
        TransactionIO this$inOut = this.getInOut();
        TransactionIO other$inOut = other.getInOut();
        if (this$inOut == null ? other$inOut != null : !((Object)this$inOut).equals(other$inOut)) {
            return false;
        }
        CurrencyCollection this$totalFees = this.getTotalFees();
        CurrencyCollection other$totalFees = other.getTotalFees();
        if (this$totalFees == null ? other$totalFees != null : !((Object)this$totalFees).equals(other$totalFees)) {
            return false;
        }
        HashUpdate this$stateUpdate = this.getStateUpdate();
        HashUpdate other$stateUpdate = other.getStateUpdate();
        if (this$stateUpdate == null ? other$stateUpdate != null : !((Object)this$stateUpdate).equals(other$stateUpdate)) {
            return false;
        }
        TransactionDescription this$description = this.getDescription();
        TransactionDescription other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        long $now = this.getNow();
        result = result * 59 + (int)($now >>> 32 ^ $now);
        long $outMsgCount = this.getOutMsgCount();
        result = result * 59 + (int)($outMsgCount >>> 32 ^ $outMsgCount);
        String $accountAddr = this.getAccountAddr();
        result = result * 59 + ($accountAddr == null ? 43 : $accountAddr.hashCode());
        BigInteger $lt = this.getLt();
        result = result * 59 + ($lt == null ? 43 : ((Object)$lt).hashCode());
        String $prevTxHash = this.getPrevTxHash();
        result = result * 59 + ($prevTxHash == null ? 43 : $prevTxHash.hashCode());
        BigInteger $prevTxLt = this.getPrevTxLt();
        result = result * 59 + ($prevTxLt == null ? 43 : ((Object)$prevTxLt).hashCode());
        AccountStates $origStatus = this.getOrigStatus();
        result = result * 59 + ($origStatus == null ? 43 : ((Object)((Object)$origStatus)).hashCode());
        AccountStates $endStatus = this.getEndStatus();
        result = result * 59 + ($endStatus == null ? 43 : ((Object)((Object)$endStatus)).hashCode());
        TransactionIO $inOut = this.getInOut();
        result = result * 59 + ($inOut == null ? 43 : ((Object)$inOut).hashCode());
        CurrencyCollection $totalFees = this.getTotalFees();
        result = result * 59 + ($totalFees == null ? 43 : ((Object)$totalFees).hashCode());
        HashUpdate $stateUpdate = this.getStateUpdate();
        result = result * 59 + ($stateUpdate == null ? 43 : ((Object)$stateUpdate).hashCode());
        TransactionDescription $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "Transaction(magic=" + this.getMagic() + ", accountAddr=" + this.getAccountAddr() + ", lt=" + String.valueOf(this.getLt()) + ", prevTxHash=" + this.getPrevTxHash() + ", prevTxLt=" + String.valueOf(this.getPrevTxLt()) + ", now=" + this.getNow() + ", outMsgCount=" + this.getOutMsgCount() + ", origStatus=" + String.valueOf((Object)this.getOrigStatus()) + ", endStatus=" + String.valueOf((Object)this.getEndStatus()) + ", inOut=" + String.valueOf(this.getInOut()) + ", totalFees=" + String.valueOf(this.getTotalFees()) + ", stateUpdate=" + String.valueOf(this.getStateUpdate()) + ", description=" + String.valueOf(this.getDescription()) + ")";
    }

    public static class TransactionBuilder {
        private int magic;
        private BigInteger accountAddr;
        private BigInteger lt;
        private BigInteger prevTxHash;
        private BigInteger prevTxLt;
        private long now;
        private long outMsgCount;
        private AccountStates origStatus;
        private AccountStates endStatus;
        private TransactionIO inOut;
        private CurrencyCollection totalFees;
        private HashUpdate stateUpdate;
        private TransactionDescription description;

        TransactionBuilder() {
        }

        public TransactionBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public TransactionBuilder accountAddr(BigInteger accountAddr) {
            this.accountAddr = accountAddr;
            return this;
        }

        public TransactionBuilder lt(BigInteger lt) {
            this.lt = lt;
            return this;
        }

        public TransactionBuilder prevTxHash(BigInteger prevTxHash) {
            this.prevTxHash = prevTxHash;
            return this;
        }

        public TransactionBuilder prevTxLt(BigInteger prevTxLt) {
            this.prevTxLt = prevTxLt;
            return this;
        }

        public TransactionBuilder now(long now) {
            this.now = now;
            return this;
        }

        public TransactionBuilder outMsgCount(long outMsgCount) {
            this.outMsgCount = outMsgCount;
            return this;
        }

        public TransactionBuilder origStatus(AccountStates origStatus) {
            this.origStatus = origStatus;
            return this;
        }

        public TransactionBuilder endStatus(AccountStates endStatus) {
            this.endStatus = endStatus;
            return this;
        }

        public TransactionBuilder inOut(TransactionIO inOut) {
            this.inOut = inOut;
            return this;
        }

        public TransactionBuilder totalFees(CurrencyCollection totalFees) {
            this.totalFees = totalFees;
            return this;
        }

        public TransactionBuilder stateUpdate(HashUpdate stateUpdate) {
            this.stateUpdate = stateUpdate;
            return this;
        }

        public TransactionBuilder description(TransactionDescription description) {
            this.description = description;
            return this;
        }

        public Transaction build() {
            return new Transaction(this.magic, this.accountAddr, this.lt, this.prevTxHash, this.prevTxLt, this.now, this.outMsgCount, this.origStatus, this.endStatus, this.inOut, this.totalFees, this.stateUpdate, this.description);
        }

        public String toString() {
            return "Transaction.TransactionBuilder(magic=" + this.magic + ", accountAddr=" + String.valueOf(this.accountAddr) + ", lt=" + String.valueOf(this.lt) + ", prevTxHash=" + String.valueOf(this.prevTxHash) + ", prevTxLt=" + String.valueOf(this.prevTxLt) + ", now=" + this.now + ", outMsgCount=" + this.outMsgCount + ", origStatus=" + String.valueOf((Object)this.origStatus) + ", endStatus=" + String.valueOf((Object)this.endStatus) + ", inOut=" + String.valueOf(this.inOut) + ", totalFees=" + String.valueOf(this.totalFees) + ", stateUpdate=" + String.valueOf(this.stateUpdate) + ", description=" + String.valueOf(this.description) + ")";
        }
    }
}

