/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.util.Arrays;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class Text
implements Serializable {
    private static final int MaxTextChunkSize = 125;
    int maxFirstChunkSize;
    String value;
    private byte[] val;
    private int chunksNum = 1;

    public Cell toCell() {
        if (this.value.isEmpty()) {
            return CellBuilder.beginCell().storeUint(0, 8).endCell();
        }
        if (this.maxFirstChunkSize > 125) {
            throw new Error("too big first chunk size");
        }
        if (this.maxFirstChunkSize == 0) {
            throw new Error("first chunk size should be greater than 0");
        }
        this.val = this.value.getBytes();
        int leftSize = this.val.length - this.maxFirstChunkSize;
        this.chunksNum = 1;
        if (leftSize > 0) {
            this.chunksNum += leftSize / 125;
            if (leftSize % 125 > 0) {
                ++this.chunksNum;
            }
        }
        if (this.chunksNum > 255) {
            throw new Error("too big data");
        }
        return CellBuilder.beginCell().storeUint(this.chunksNum, 8).storeSlice(CellSlice.beginParse((Cell)this.f(0).endCell())).endCell();
    }

    public static Text deserialize(CellSlice cs) {
        int chunksNum = cs.loadUint(8).intValue();
        int firstSize = 0;
        int lengthOfChunk = 0;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < chunksNum; ++i) {
            lengthOfChunk = cs.loadUint(8).intValue();
            if (i == 0) {
                firstSize = lengthOfChunk;
            }
            byte[] dataOfChunk = cs.loadBytes(lengthOfChunk * 8);
            result.append(new String(dataOfChunk));
            if (i >= chunksNum - 1) continue;
            cs = CellSlice.beginParse((Cell)cs.loadRef());
        }
        return Text.builder().maxFirstChunkSize(firstSize).value(result.toString()).build();
    }

    private CellBuilder f(int depth) {
        CellBuilder c = CellBuilder.beginCell();
        int sz = 125;
        if (depth == 0) {
            sz = this.maxFirstChunkSize;
        }
        if (sz > this.val.length) {
            sz = this.val.length;
        }
        c.storeUint(sz, 8);
        byte[] textPiece = Arrays.copyOfRange(this.val, 0, sz);
        c.storeBytes(textPiece, sz * 8);
        this.val = Arrays.copyOfRange(this.val, sz, this.val.length);
        if (depth != this.chunksNum - 1) {
            c.storeRef(this.f(depth + 1).endCell());
        }
        return c;
    }

    Text(int maxFirstChunkSize, String value, byte[] val, int chunksNum) {
        this.maxFirstChunkSize = maxFirstChunkSize;
        this.value = value;
        this.val = val;
        this.chunksNum = chunksNum;
    }

    public static TextBuilder builder() {
        return new TextBuilder();
    }

    public int getMaxFirstChunkSize() {
        return this.maxFirstChunkSize;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getVal() {
        return this.val;
    }

    public int getChunksNum() {
        return this.chunksNum;
    }

    public void setMaxFirstChunkSize(int maxFirstChunkSize) {
        this.maxFirstChunkSize = maxFirstChunkSize;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setVal(byte[] val) {
        this.val = val;
    }

    public void setChunksNum(int chunksNum) {
        this.chunksNum = chunksNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text other = (Text)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxFirstChunkSize() != other.getMaxFirstChunkSize()) {
            return false;
        }
        if (this.getChunksNum() != other.getChunksNum()) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return Arrays.equals(this.getVal(), other.getVal());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Text;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxFirstChunkSize();
        result = result * 59 + this.getChunksNum();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVal());
        return result;
    }

    public String toString() {
        return "Text(maxFirstChunkSize=" + this.getMaxFirstChunkSize() + ", value=" + this.getValue() + ")";
    }

    public static class TextBuilder {
        private int maxFirstChunkSize;
        private String value;
        private byte[] val;
        private int chunksNum;

        TextBuilder() {
        }

        public TextBuilder maxFirstChunkSize(int maxFirstChunkSize) {
            this.maxFirstChunkSize = maxFirstChunkSize;
            return this;
        }

        public TextBuilder value(String value) {
            this.value = value;
            return this;
        }

        public TextBuilder val(byte[] val) {
            this.val = val;
            return this;
        }

        public TextBuilder chunksNum(int chunksNum) {
            this.chunksNum = chunksNum;
            return this;
        }

        public Text build() {
            return new Text(this.maxFirstChunkSize, this.value, this.val, this.chunksNum);
        }

        public String toString() {
            return "Text.TextBuilder(maxFirstChunkSize=" + this.maxFirstChunkSize + ", value=" + this.value + ", val=" + Arrays.toString(this.val) + ", chunksNum=" + this.chunksNum + ")";
        }
    }
}

