/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class StoragePrices
implements Serializable {
    long magic;
    long utimeSince;
    BigInteger bitPricePs;
    BigInteger cellPricePs;
    BigInteger mcBitPricePs;
    BigInteger mcCellPricePs;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(204, 8).storeUint(this.utimeSince, 32).storeUint(this.bitPricePs, 64).storeUint(this.cellPricePs, 64).storeUint(this.mcBitPricePs, 64).storeUint(this.mcCellPricePs, 64).endCell();
    }

    public static StoragePrices deserialize(CellSlice cs) {
        return StoragePrices.builder().magic(cs.loadUint(8).longValue()).utimeSince(cs.loadUint(32).longValue()).bitPricePs(cs.loadUint(64)).cellPricePs(cs.loadUint(64)).mcBitPricePs(cs.loadUint(64)).mcCellPricePs(cs.loadUint(64)).build();
    }

    StoragePrices(long magic, long utimeSince, BigInteger bitPricePs, BigInteger cellPricePs, BigInteger mcBitPricePs, BigInteger mcCellPricePs) {
        this.magic = magic;
        this.utimeSince = utimeSince;
        this.bitPricePs = bitPricePs;
        this.cellPricePs = cellPricePs;
        this.mcBitPricePs = mcBitPricePs;
        this.mcCellPricePs = mcCellPricePs;
    }

    public static StoragePricesBuilder builder() {
        return new StoragePricesBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public long getUtimeSince() {
        return this.utimeSince;
    }

    public BigInteger getBitPricePs() {
        return this.bitPricePs;
    }

    public BigInteger getCellPricePs() {
        return this.cellPricePs;
    }

    public BigInteger getMcBitPricePs() {
        return this.mcBitPricePs;
    }

    public BigInteger getMcCellPricePs() {
        return this.mcCellPricePs;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setUtimeSince(long utimeSince) {
        this.utimeSince = utimeSince;
    }

    public void setBitPricePs(BigInteger bitPricePs) {
        this.bitPricePs = bitPricePs;
    }

    public void setCellPricePs(BigInteger cellPricePs) {
        this.cellPricePs = cellPricePs;
    }

    public void setMcBitPricePs(BigInteger mcBitPricePs) {
        this.mcBitPricePs = mcBitPricePs;
    }

    public void setMcCellPricePs(BigInteger mcCellPricePs) {
        this.mcCellPricePs = mcCellPricePs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoragePrices)) {
            return false;
        }
        StoragePrices other = (StoragePrices)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getUtimeSince() != other.getUtimeSince()) {
            return false;
        }
        BigInteger this$bitPricePs = this.getBitPricePs();
        BigInteger other$bitPricePs = other.getBitPricePs();
        if (this$bitPricePs == null ? other$bitPricePs != null : !((Object)this$bitPricePs).equals(other$bitPricePs)) {
            return false;
        }
        BigInteger this$cellPricePs = this.getCellPricePs();
        BigInteger other$cellPricePs = other.getCellPricePs();
        if (this$cellPricePs == null ? other$cellPricePs != null : !((Object)this$cellPricePs).equals(other$cellPricePs)) {
            return false;
        }
        BigInteger this$mcBitPricePs = this.getMcBitPricePs();
        BigInteger other$mcBitPricePs = other.getMcBitPricePs();
        if (this$mcBitPricePs == null ? other$mcBitPricePs != null : !((Object)this$mcBitPricePs).equals(other$mcBitPricePs)) {
            return false;
        }
        BigInteger this$mcCellPricePs = this.getMcCellPricePs();
        BigInteger other$mcCellPricePs = other.getMcCellPricePs();
        return !(this$mcCellPricePs == null ? other$mcCellPricePs != null : !((Object)this$mcCellPricePs).equals(other$mcCellPricePs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoragePrices;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        long $utimeSince = this.getUtimeSince();
        result = result * 59 + (int)($utimeSince >>> 32 ^ $utimeSince);
        BigInteger $bitPricePs = this.getBitPricePs();
        result = result * 59 + ($bitPricePs == null ? 43 : ((Object)$bitPricePs).hashCode());
        BigInteger $cellPricePs = this.getCellPricePs();
        result = result * 59 + ($cellPricePs == null ? 43 : ((Object)$cellPricePs).hashCode());
        BigInteger $mcBitPricePs = this.getMcBitPricePs();
        result = result * 59 + ($mcBitPricePs == null ? 43 : ((Object)$mcBitPricePs).hashCode());
        BigInteger $mcCellPricePs = this.getMcCellPricePs();
        result = result * 59 + ($mcCellPricePs == null ? 43 : ((Object)$mcCellPricePs).hashCode());
        return result;
    }

    public String toString() {
        return "StoragePrices(magic=" + this.getMagic() + ", utimeSince=" + this.getUtimeSince() + ", bitPricePs=" + String.valueOf(this.getBitPricePs()) + ", cellPricePs=" + String.valueOf(this.getCellPricePs()) + ", mcBitPricePs=" + String.valueOf(this.getMcBitPricePs()) + ", mcCellPricePs=" + String.valueOf(this.getMcCellPricePs()) + ")";
    }

    public static class StoragePricesBuilder {
        private long magic;
        private long utimeSince;
        private BigInteger bitPricePs;
        private BigInteger cellPricePs;
        private BigInteger mcBitPricePs;
        private BigInteger mcCellPricePs;

        StoragePricesBuilder() {
        }

        public StoragePricesBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public StoragePricesBuilder utimeSince(long utimeSince) {
            this.utimeSince = utimeSince;
            return this;
        }

        public StoragePricesBuilder bitPricePs(BigInteger bitPricePs) {
            this.bitPricePs = bitPricePs;
            return this;
        }

        public StoragePricesBuilder cellPricePs(BigInteger cellPricePs) {
            this.cellPricePs = cellPricePs;
            return this;
        }

        public StoragePricesBuilder mcBitPricePs(BigInteger mcBitPricePs) {
            this.mcBitPricePs = mcBitPricePs;
            return this;
        }

        public StoragePricesBuilder mcCellPricePs(BigInteger mcCellPricePs) {
            this.mcCellPricePs = mcCellPricePs;
            return this;
        }

        public StoragePrices build() {
            return new StoragePrices(this.magic, this.utimeSince, this.bitPricePs, this.cellPricePs, this.mcBitPricePs, this.mcCellPricePs);
        }

        public String toString() {
            return "StoragePrices.StoragePricesBuilder(magic=" + this.magic + ", utimeSince=" + this.utimeSince + ", bitPricePs=" + String.valueOf(this.bitPricePs) + ", cellPricePs=" + String.valueOf(this.cellPricePs) + ", mcBitPricePs=" + String.valueOf(this.mcBitPricePs) + ", mcCellPricePs=" + String.valueOf(this.mcCellPricePs) + ")";
        }
    }
}

