/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.StorageExtraInfo;
import org.ton.java.tlb.StorageUsed;

public class StorageInfo
implements Serializable {
    StorageUsed storageUsed;
    StorageExtraInfo storageExtraInfo;
    long lastPaid;
    BigInteger duePayment;

    public Cell toCell() {
        return CellBuilder.beginCell().storeCell(this.storageUsed.toCell()).storeCell(this.storageExtraInfo.toCell()).storeUint(this.lastPaid, 32).storeCoinsMaybe(this.duePayment).endCell();
    }

    public static StorageInfo deserialize(CellSlice cs) {
        return StorageInfo.builder().storageUsed(StorageUsed.deserialize(cs)).storageExtraInfo(StorageExtraInfo.deserialize(cs)).lastPaid(cs.loadUint(32).longValue()).duePayment(cs.loadBit() ? cs.loadCoins() : null).build();
    }

    StorageInfo(StorageUsed storageUsed, StorageExtraInfo storageExtraInfo, long lastPaid, BigInteger duePayment) {
        this.storageUsed = storageUsed;
        this.storageExtraInfo = storageExtraInfo;
        this.lastPaid = lastPaid;
        this.duePayment = duePayment;
    }

    public static StorageInfoBuilder builder() {
        return new StorageInfoBuilder();
    }

    public StorageUsed getStorageUsed() {
        return this.storageUsed;
    }

    public StorageExtraInfo getStorageExtraInfo() {
        return this.storageExtraInfo;
    }

    public long getLastPaid() {
        return this.lastPaid;
    }

    public BigInteger getDuePayment() {
        return this.duePayment;
    }

    public void setStorageUsed(StorageUsed storageUsed) {
        this.storageUsed = storageUsed;
    }

    public void setStorageExtraInfo(StorageExtraInfo storageExtraInfo) {
        this.storageExtraInfo = storageExtraInfo;
    }

    public void setLastPaid(long lastPaid) {
        this.lastPaid = lastPaid;
    }

    public void setDuePayment(BigInteger duePayment) {
        this.duePayment = duePayment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageInfo)) {
            return false;
        }
        StorageInfo other = (StorageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastPaid() != other.getLastPaid()) {
            return false;
        }
        StorageUsed this$storageUsed = this.getStorageUsed();
        StorageUsed other$storageUsed = other.getStorageUsed();
        if (this$storageUsed == null ? other$storageUsed != null : !((Object)this$storageUsed).equals(other$storageUsed)) {
            return false;
        }
        StorageExtraInfo this$storageExtraInfo = this.getStorageExtraInfo();
        StorageExtraInfo other$storageExtraInfo = other.getStorageExtraInfo();
        if (this$storageExtraInfo == null ? other$storageExtraInfo != null : !this$storageExtraInfo.equals(other$storageExtraInfo)) {
            return false;
        }
        BigInteger this$duePayment = this.getDuePayment();
        BigInteger other$duePayment = other.getDuePayment();
        return !(this$duePayment == null ? other$duePayment != null : !((Object)this$duePayment).equals(other$duePayment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StorageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastPaid = this.getLastPaid();
        result = result * 59 + (int)($lastPaid >>> 32 ^ $lastPaid);
        StorageUsed $storageUsed = this.getStorageUsed();
        result = result * 59 + ($storageUsed == null ? 43 : ((Object)$storageUsed).hashCode());
        StorageExtraInfo $storageExtraInfo = this.getStorageExtraInfo();
        result = result * 59 + ($storageExtraInfo == null ? 43 : $storageExtraInfo.hashCode());
        BigInteger $duePayment = this.getDuePayment();
        result = result * 59 + ($duePayment == null ? 43 : ((Object)$duePayment).hashCode());
        return result;
    }

    public String toString() {
        return "StorageInfo(storageUsed=" + String.valueOf(this.getStorageUsed()) + ", storageExtraInfo=" + String.valueOf(this.getStorageExtraInfo()) + ", lastPaid=" + this.getLastPaid() + ", duePayment=" + String.valueOf(this.getDuePayment()) + ")";
    }

    public static class StorageInfoBuilder {
        private StorageUsed storageUsed;
        private StorageExtraInfo storageExtraInfo;
        private long lastPaid;
        private BigInteger duePayment;

        StorageInfoBuilder() {
        }

        public StorageInfoBuilder storageUsed(StorageUsed storageUsed) {
            this.storageUsed = storageUsed;
            return this;
        }

        public StorageInfoBuilder storageExtraInfo(StorageExtraInfo storageExtraInfo) {
            this.storageExtraInfo = storageExtraInfo;
            return this;
        }

        public StorageInfoBuilder lastPaid(long lastPaid) {
            this.lastPaid = lastPaid;
            return this;
        }

        public StorageInfoBuilder duePayment(BigInteger duePayment) {
            this.duePayment = duePayment;
            return this;
        }

        public StorageInfo build() {
            return new StorageInfo(this.storageUsed, this.storageExtraInfo, this.lastPaid, this.duePayment);
        }

        public String toString() {
            return "StorageInfo.StorageInfoBuilder(storageUsed=" + String.valueOf(this.storageUsed) + ", storageExtraInfo=" + String.valueOf(this.storageExtraInfo) + ", lastPaid=" + this.lastPaid + ", duePayment=" + String.valueOf(this.duePayment) + ")";
        }
    }
}

