/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.StorageExtraInfo;

public class StorageExtraInformation
implements StorageExtraInfo,
Serializable {
    int magic;
    BigInteger dictHash;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 3).storeUint(this.dictHash, 256).endCell();
    }

    public static StorageExtraInformation deserialize(CellSlice cs) {
        return StorageExtraInformation.builder().magic(cs.loadUint(3).intValue()).dictHash(cs.loadUint(256)).build();
    }

    StorageExtraInformation(int magic, BigInteger dictHash) {
        this.magic = magic;
        this.dictHash = dictHash;
    }

    public static StorageExtraInformationBuilder builder() {
        return new StorageExtraInformationBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public BigInteger getDictHash() {
        return this.dictHash;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setDictHash(BigInteger dictHash) {
        this.dictHash = dictHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageExtraInformation)) {
            return false;
        }
        StorageExtraInformation other = (StorageExtraInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$dictHash = this.getDictHash();
        BigInteger other$dictHash = other.getDictHash();
        return !(this$dictHash == null ? other$dictHash != null : !((Object)this$dictHash).equals(other$dictHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StorageExtraInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        BigInteger $dictHash = this.getDictHash();
        result = result * 59 + ($dictHash == null ? 43 : ((Object)$dictHash).hashCode());
        return result;
    }

    public String toString() {
        return "StorageExtraInformation(magic=" + this.getMagic() + ", dictHash=" + String.valueOf(this.getDictHash()) + ")";
    }

    public static class StorageExtraInformationBuilder {
        private int magic;
        private BigInteger dictHash;

        StorageExtraInformationBuilder() {
        }

        public StorageExtraInformationBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public StorageExtraInformationBuilder dictHash(BigInteger dictHash) {
            this.dictHash = dictHash;
            return this;
        }

        public StorageExtraInformation build() {
            return new StorageExtraInformation(this.magic, this.dictHash);
        }

        public String toString() {
            return "StorageExtraInformation.StorageExtraInformationBuilder(magic=" + this.magic + ", dictHash=" + String.valueOf(this.dictHash) + ")";
        }
    }
}

