/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.MsgAddressInt;

public class SmcInfo
implements Serializable {
    int magic;
    long actions;
    long msgsSent;
    long unixtime;
    BigInteger blockLt;
    BigInteger transLt;
    BigInteger randSeed;
    CurrencyCollection balanceRemaining;
    MsgAddressInt myself;
    Cell globalConfig;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(124711402, 32).storeUint(this.actions, 16).storeUint(this.msgsSent, 16).storeUint(this.unixtime, 32).storeUint(Objects.isNull(this.blockLt) ? BigInteger.ZERO : this.blockLt, 64).storeUint(Objects.isNull(this.transLt) ? BigInteger.ZERO : this.transLt, 64).storeUint(Objects.isNull(this.randSeed) ? BigInteger.ZERO : this.randSeed, 256).storeCell(this.balanceRemaining.toCell()).storeCell(this.myself.toCell()).storeCellMaybe(this.globalConfig).endCell();
    }

    public static SmcInfo deserialize(CellSlice cs) {
        return SmcInfo.builder().magic(cs.loadUint(32).intValue()).actions(cs.loadUint(16).longValue()).msgsSent(cs.loadUint(16).longValue()).unixtime(cs.loadUint(32).longValue()).blockLt(cs.loadUint(64)).transLt(cs.loadUint(64)).randSeed(cs.loadUint(256)).balanceRemaining(CurrencyCollection.deserialize(cs)).myself(MsgAddressInt.deserialize(cs)).globalConfig(CellSlice.beginParse((Object)cs).sliceToCell()).build();
    }

    SmcInfo(int magic, long actions, long msgsSent, long unixtime, BigInteger blockLt, BigInteger transLt, BigInteger randSeed, CurrencyCollection balanceRemaining, MsgAddressInt myself, Cell globalConfig) {
        this.magic = magic;
        this.actions = actions;
        this.msgsSent = msgsSent;
        this.unixtime = unixtime;
        this.blockLt = blockLt;
        this.transLt = transLt;
        this.randSeed = randSeed;
        this.balanceRemaining = balanceRemaining;
        this.myself = myself;
        this.globalConfig = globalConfig;
    }

    public static SmcInfoBuilder builder() {
        return new SmcInfoBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public long getActions() {
        return this.actions;
    }

    public long getMsgsSent() {
        return this.msgsSent;
    }

    public long getUnixtime() {
        return this.unixtime;
    }

    public BigInteger getBlockLt() {
        return this.blockLt;
    }

    public BigInteger getTransLt() {
        return this.transLt;
    }

    public BigInteger getRandSeed() {
        return this.randSeed;
    }

    public CurrencyCollection getBalanceRemaining() {
        return this.balanceRemaining;
    }

    public MsgAddressInt getMyself() {
        return this.myself;
    }

    public Cell getGlobalConfig() {
        return this.globalConfig;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setActions(long actions) {
        this.actions = actions;
    }

    public void setMsgsSent(long msgsSent) {
        this.msgsSent = msgsSent;
    }

    public void setUnixtime(long unixtime) {
        this.unixtime = unixtime;
    }

    public void setBlockLt(BigInteger blockLt) {
        this.blockLt = blockLt;
    }

    public void setTransLt(BigInteger transLt) {
        this.transLt = transLt;
    }

    public void setRandSeed(BigInteger randSeed) {
        this.randSeed = randSeed;
    }

    public void setBalanceRemaining(CurrencyCollection balanceRemaining) {
        this.balanceRemaining = balanceRemaining;
    }

    public void setMyself(MsgAddressInt myself) {
        this.myself = myself;
    }

    public void setGlobalConfig(Cell globalConfig) {
        this.globalConfig = globalConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmcInfo)) {
            return false;
        }
        SmcInfo other = (SmcInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getActions() != other.getActions()) {
            return false;
        }
        if (this.getMsgsSent() != other.getMsgsSent()) {
            return false;
        }
        if (this.getUnixtime() != other.getUnixtime()) {
            return false;
        }
        BigInteger this$blockLt = this.getBlockLt();
        BigInteger other$blockLt = other.getBlockLt();
        if (this$blockLt == null ? other$blockLt != null : !((Object)this$blockLt).equals(other$blockLt)) {
            return false;
        }
        BigInteger this$transLt = this.getTransLt();
        BigInteger other$transLt = other.getTransLt();
        if (this$transLt == null ? other$transLt != null : !((Object)this$transLt).equals(other$transLt)) {
            return false;
        }
        BigInteger this$randSeed = this.getRandSeed();
        BigInteger other$randSeed = other.getRandSeed();
        if (this$randSeed == null ? other$randSeed != null : !((Object)this$randSeed).equals(other$randSeed)) {
            return false;
        }
        CurrencyCollection this$balanceRemaining = this.getBalanceRemaining();
        CurrencyCollection other$balanceRemaining = other.getBalanceRemaining();
        if (this$balanceRemaining == null ? other$balanceRemaining != null : !((Object)this$balanceRemaining).equals(other$balanceRemaining)) {
            return false;
        }
        MsgAddressInt this$myself = this.getMyself();
        MsgAddressInt other$myself = other.getMyself();
        if (this$myself == null ? other$myself != null : !this$myself.equals(other$myself)) {
            return false;
        }
        Cell this$globalConfig = this.getGlobalConfig();
        Cell other$globalConfig = other.getGlobalConfig();
        return !(this$globalConfig == null ? other$globalConfig != null : !this$globalConfig.equals(other$globalConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmcInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        long $actions = this.getActions();
        result = result * 59 + (int)($actions >>> 32 ^ $actions);
        long $msgsSent = this.getMsgsSent();
        result = result * 59 + (int)($msgsSent >>> 32 ^ $msgsSent);
        long $unixtime = this.getUnixtime();
        result = result * 59 + (int)($unixtime >>> 32 ^ $unixtime);
        BigInteger $blockLt = this.getBlockLt();
        result = result * 59 + ($blockLt == null ? 43 : ((Object)$blockLt).hashCode());
        BigInteger $transLt = this.getTransLt();
        result = result * 59 + ($transLt == null ? 43 : ((Object)$transLt).hashCode());
        BigInteger $randSeed = this.getRandSeed();
        result = result * 59 + ($randSeed == null ? 43 : ((Object)$randSeed).hashCode());
        CurrencyCollection $balanceRemaining = this.getBalanceRemaining();
        result = result * 59 + ($balanceRemaining == null ? 43 : ((Object)$balanceRemaining).hashCode());
        MsgAddressInt $myself = this.getMyself();
        result = result * 59 + ($myself == null ? 43 : $myself.hashCode());
        Cell $globalConfig = this.getGlobalConfig();
        result = result * 59 + ($globalConfig == null ? 43 : $globalConfig.hashCode());
        return result;
    }

    public String toString() {
        return "SmcInfo(magic=" + this.getMagic() + ", actions=" + this.getActions() + ", msgsSent=" + this.getMsgsSent() + ", unixtime=" + this.getUnixtime() + ", blockLt=" + String.valueOf(this.getBlockLt()) + ", transLt=" + String.valueOf(this.getTransLt()) + ", randSeed=" + String.valueOf(this.getRandSeed()) + ", balanceRemaining=" + String.valueOf(this.getBalanceRemaining()) + ", myself=" + String.valueOf(this.getMyself()) + ", globalConfig=" + String.valueOf(this.getGlobalConfig()) + ")";
    }

    public static class SmcInfoBuilder {
        private int magic;
        private long actions;
        private long msgsSent;
        private long unixtime;
        private BigInteger blockLt;
        private BigInteger transLt;
        private BigInteger randSeed;
        private CurrencyCollection balanceRemaining;
        private MsgAddressInt myself;
        private Cell globalConfig;

        SmcInfoBuilder() {
        }

        public SmcInfoBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public SmcInfoBuilder actions(long actions) {
            this.actions = actions;
            return this;
        }

        public SmcInfoBuilder msgsSent(long msgsSent) {
            this.msgsSent = msgsSent;
            return this;
        }

        public SmcInfoBuilder unixtime(long unixtime) {
            this.unixtime = unixtime;
            return this;
        }

        public SmcInfoBuilder blockLt(BigInteger blockLt) {
            this.blockLt = blockLt;
            return this;
        }

        public SmcInfoBuilder transLt(BigInteger transLt) {
            this.transLt = transLt;
            return this;
        }

        public SmcInfoBuilder randSeed(BigInteger randSeed) {
            this.randSeed = randSeed;
            return this;
        }

        public SmcInfoBuilder balanceRemaining(CurrencyCollection balanceRemaining) {
            this.balanceRemaining = balanceRemaining;
            return this;
        }

        public SmcInfoBuilder myself(MsgAddressInt myself) {
            this.myself = myself;
            return this;
        }

        public SmcInfoBuilder globalConfig(Cell globalConfig) {
            this.globalConfig = globalConfig;
            return this;
        }

        public SmcInfo build() {
            return new SmcInfo(this.magic, this.actions, this.msgsSent, this.unixtime, this.blockLt, this.transLt, this.randSeed, this.balanceRemaining, this.myself, this.globalConfig);
        }

        public String toString() {
            return "SmcInfo.SmcInfoBuilder(magic=" + this.magic + ", actions=" + this.actions + ", msgsSent=" + this.msgsSent + ", unixtime=" + this.unixtime + ", blockLt=" + String.valueOf(this.blockLt) + ", transLt=" + String.valueOf(this.transLt) + ", randSeed=" + String.valueOf(this.randSeed) + ", balanceRemaining=" + String.valueOf(this.balanceRemaining) + ", myself=" + String.valueOf(this.myself) + ", globalConfig=" + String.valueOf(this.globalConfig) + ")";
        }
    }
}

