/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class SigPubKey
implements Serializable {
    long magic;
    BigInteger pubkey;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(-1904138358, 32).storeUint(this.pubkey, 256).endCell();
    }

    public static SigPubKey deserialize(CellSlice cs) {
        return SigPubKey.builder().magic(cs.loadUint(32).longValue()).pubkey(cs.loadUint(256)).build();
    }

    SigPubKey(long magic, BigInteger pubkey) {
        this.magic = magic;
        this.pubkey = pubkey;
    }

    public static SigPubKeyBuilder builder() {
        return new SigPubKeyBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public BigInteger getPubkey() {
        return this.pubkey;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setPubkey(BigInteger pubkey) {
        this.pubkey = pubkey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SigPubKey)) {
            return false;
        }
        SigPubKey other = (SigPubKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$pubkey = this.getPubkey();
        BigInteger other$pubkey = other.getPubkey();
        return !(this$pubkey == null ? other$pubkey != null : !((Object)this$pubkey).equals(other$pubkey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SigPubKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        BigInteger $pubkey = this.getPubkey();
        result = result * 59 + ($pubkey == null ? 43 : ((Object)$pubkey).hashCode());
        return result;
    }

    public String toString() {
        return "SigPubKey(magic=" + this.getMagic() + ", pubkey=" + String.valueOf(this.getPubkey()) + ")";
    }

    public static class SigPubKeyBuilder {
        private long magic;
        private BigInteger pubkey;

        SigPubKeyBuilder() {
        }

        public SigPubKeyBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public SigPubKeyBuilder pubkey(BigInteger pubkey) {
            this.pubkey = pubkey;
            return this;
        }

        public SigPubKey build() {
            return new SigPubKey(this.magic, this.pubkey);
        }

        public String toString() {
            return "SigPubKey.SigPubKeyBuilder(magic=" + this.magic + ", pubkey=" + String.valueOf(this.pubkey) + ")";
        }
    }
}

