/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ShardStateUnsplit;

public class ShardState
implements Serializable {
    long magic;
    ShardStateUnsplit left;
    ShardStateUnsplit right;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    public Cell toCell() {
        if (this.magic == 1597144485L) {
            return CellBuilder.beginCell().storeUint(1597144485L, 32).storeRef(this.left.toCell()).storeRef(this.right.toCell()).endCell();
        }
        if (this.magic == 2418257890L) {
            return CellBuilder.beginCell().storeUint(2418257890L, 32).storeCell(this.left.toCell()).endCell();
        }
        throw new Error("wrong magic number");
    }

    public static ShardState deserialize(CellSlice cs) {
        long tag = cs.preloadUint(32).longValue();
        if (tag == 1597144485L) {
            ShardStateUnsplit left = ShardStateUnsplit.deserialize(CellSlice.beginParse((Cell)cs.loadRef()));
            ShardStateUnsplit right = ShardStateUnsplit.deserialize(CellSlice.beginParse((Cell)cs.loadRef()));
            return ShardState.builder().magic(tag).left(left).right(right).build();
        }
        return ShardState.builder().magic(tag).left(ShardStateUnsplit.deserialize(cs)).build();
    }

    ShardState(long magic, ShardStateUnsplit left, ShardStateUnsplit right) {
        this.magic = magic;
        this.left = left;
        this.right = right;
    }

    public static ShardStateBuilder builder() {
        return new ShardStateBuilder();
    }

    public ShardStateUnsplit getLeft() {
        return this.left;
    }

    public ShardStateUnsplit getRight() {
        return this.right;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setLeft(ShardStateUnsplit left) {
        this.left = left;
    }

    public void setRight(ShardStateUnsplit right) {
        this.right = right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardState)) {
            return false;
        }
        ShardState other = (ShardState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        ShardStateUnsplit this$left = this.getLeft();
        ShardStateUnsplit other$left = other.getLeft();
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        ShardStateUnsplit this$right = this.getRight();
        ShardStateUnsplit other$right = other.getRight();
        return !(this$right == null ? other$right != null : !((Object)this$right).equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        ShardStateUnsplit $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        ShardStateUnsplit $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : ((Object)$right).hashCode());
        return result;
    }

    public String toString() {
        return "ShardState(magic=" + this.getMagic() + ", left=" + String.valueOf(this.getLeft()) + ", right=" + String.valueOf(this.getRight()) + ")";
    }

    public static class ShardStateBuilder {
        private long magic;
        private ShardStateUnsplit left;
        private ShardStateUnsplit right;

        ShardStateBuilder() {
        }

        public ShardStateBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ShardStateBuilder left(ShardStateUnsplit left) {
            this.left = left;
            return this;
        }

        public ShardStateBuilder right(ShardStateUnsplit right) {
            this.right = right;
            return this;
        }

        public ShardState build() {
            return new ShardState(this.magic, this.left, this.right);
        }

        public String toString() {
            return "ShardState.ShardStateBuilder(magic=" + this.magic + ", left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + ")";
        }
    }
}

