/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ShardIdent {
    long magic;
    int prefixBits;
    int workchain;
    BigInteger shardPrefix;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(0, 2).storeUint(this.prefixBits, 6).storeInt(this.workchain, 32).storeUint(this.shardPrefix, 64).endCell();
    }

    public static ShardIdent deserialize(CellSlice cs) {
        long magic = cs.loadUint(2).longValue();
        assert (magic == 0L) : "ShardIdent: magic not equal to 0b00, found 0b" + Long.toBinaryString(magic);
        return ShardIdent.builder().magic(0L).prefixBits(cs.loadUint(6).intValue()).workchain(cs.loadInt(32).intValue()).shardPrefix(cs.loadUint(64)).build();
    }

    public BigInteger convertShardIdentToShard() {
        if (Objects.isNull(this.shardPrefix)) {
            throw new Error("Shard prefix is null, should be in range 0..60");
        }
        if (this.shardPrefix.compareTo(BigInteger.valueOf(60L)) > 0) {
            return this.shardPrefix;
        }
        return BigInteger.valueOf(2L).multiply(this.shardPrefix).add(BigInteger.ONE).shiftLeft(63 - this.prefixBits);
    }

    public BigInteger getParent() {
        BigInteger shard = this.convertShardIdentToShard();
        BigInteger x = this.lowerBit64(shard);
        BigInteger a = shard.subtract(x);
        BigInteger b = x.shiftLeft(1);
        if (b.longValue() < 0L) {
            return a.or(b);
        }
        return BigInteger.valueOf(a.longValue() | b.longValue());
    }

    public BigInteger getChildRight() {
        BigInteger shard = this.convertShardIdentToShard();
        BigInteger x = this.lowerBit64(shard).shiftRight(1);
        return shard.add(x);
    }

    public BigInteger getChildLeft() {
        BigInteger shard = this.convertShardIdentToShard();
        BigInteger x = this.lowerBit64(shard).shiftRight(1);
        return shard.subtract(x);
    }

    private BigInteger lowerBit64(BigInteger x) {
        return x.and(this.bitsNegate64(x));
    }

    public BigInteger bitsNegate64(BigInteger x) {
        BigInteger mask = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        return x.not().and(mask).add(BigInteger.ONE);
    }

    public static BigInteger ROOT() {
        return BigInteger.ONE.shiftLeft(63);
    }

    public static ShardIdent convertShardToShardIdent(String shard, int workchain) {
        return ShardIdent.builder().workchain(workchain).shardPrefix(new BigInteger(shard, 16)).build();
    }

    ShardIdent(long magic, int prefixBits, int workchain, BigInteger shardPrefix) {
        this.magic = magic;
        this.prefixBits = prefixBits;
        this.workchain = workchain;
        this.shardPrefix = shardPrefix;
    }

    public static ShardIdentBuilder builder() {
        return new ShardIdentBuilder();
    }

    public int getPrefixBits() {
        return this.prefixBits;
    }

    public int getWorkchain() {
        return this.workchain;
    }

    public BigInteger getShardPrefix() {
        return this.shardPrefix;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setPrefixBits(int prefixBits) {
        this.prefixBits = prefixBits;
    }

    public void setWorkchain(int workchain) {
        this.workchain = workchain;
    }

    public void setShardPrefix(BigInteger shardPrefix) {
        this.shardPrefix = shardPrefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardIdent)) {
            return false;
        }
        ShardIdent other = (ShardIdent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getPrefixBits() != other.getPrefixBits()) {
            return false;
        }
        if (this.getWorkchain() != other.getWorkchain()) {
            return false;
        }
        BigInteger this$shardPrefix = this.getShardPrefix();
        BigInteger other$shardPrefix = other.getShardPrefix();
        return !(this$shardPrefix == null ? other$shardPrefix != null : !((Object)this$shardPrefix).equals(other$shardPrefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardIdent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        result = result * 59 + this.getPrefixBits();
        result = result * 59 + this.getWorkchain();
        BigInteger $shardPrefix = this.getShardPrefix();
        result = result * 59 + ($shardPrefix == null ? 43 : ((Object)$shardPrefix).hashCode());
        return result;
    }

    public String toString() {
        return "ShardIdent(magic=" + this.getMagic() + ", prefixBits=" + this.getPrefixBits() + ", workchain=" + this.getWorkchain() + ", shardPrefix=" + String.valueOf(this.getShardPrefix()) + ")";
    }

    public static class ShardIdentBuilder {
        private long magic;
        private int prefixBits;
        private int workchain;
        private BigInteger shardPrefix;

        ShardIdentBuilder() {
        }

        public ShardIdentBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ShardIdentBuilder prefixBits(int prefixBits) {
            this.prefixBits = prefixBits;
            return this;
        }

        public ShardIdentBuilder workchain(int workchain) {
            this.workchain = workchain;
            return this;
        }

        public ShardIdentBuilder shardPrefix(BigInteger shardPrefix) {
            this.shardPrefix = shardPrefix;
            return this;
        }

        public ShardIdent build() {
            return new ShardIdent(this.magic, this.prefixBits, this.workchain, this.shardPrefix);
        }

        public String toString() {
            return "ShardIdent.ShardIdentBuilder(magic=" + this.magic + ", prefixBits=" + this.prefixBits + ", workchain=" + this.workchain + ", shardPrefix=" + String.valueOf(this.shardPrefix) + ")";
        }
    }
}

