/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.FutureSplitMerge;

public class ShardDescr
implements Serializable {
    long magic;
    long seqNo;
    long regMcSeqno;
    BigInteger startLt;
    BigInteger endLt;
    BigInteger rootHash;
    BigInteger fileHash;
    boolean beforeSplit;
    boolean beforeMerge;
    boolean wantSplit;
    boolean wantMerge;
    boolean nXCCUpdated;
    int flags;
    long nextCatchainSeqNo;
    BigInteger nextValidatorShard;
    long minRefMcSeqNo;
    long genUTime;
    FutureSplitMerge splitMergeAt;
    CurrencyCollection feesCollected;
    CurrencyCollection fundsCreated;
    Cell refInfoA;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    private String getRootHash() {
        return this.rootHash.toString(16);
    }

    private String getFileHash() {
        return this.fileHash.toString(16);
    }

    public Cell toCell() {
        if (this.magic == 11L) {
            return CellBuilder.beginCell().storeUint(11, 8).storeUint(this.seqNo, 32).storeUint(this.regMcSeqno, 32).storeUint(this.startLt, 64).storeUint(this.endLt, 64).storeUint(this.rootHash, 64).storeUint(this.fileHash, 64).storeBit(Boolean.valueOf(this.beforeSplit)).storeBit(Boolean.valueOf(this.beforeMerge)).storeBit(Boolean.valueOf(this.wantSplit)).storeBit(Boolean.valueOf(this.wantMerge)).storeBit(Boolean.valueOf(this.nXCCUpdated)).storeUint(this.flags, 3).storeUint(this.nextCatchainSeqNo, 32).storeUint(this.nextValidatorShard, 64).storeUint(this.minRefMcSeqNo, 32).storeUint(this.genUTime, 32).storeCell(this.splitMergeAt.toCell()).storeCell(this.feesCollected.toCell()).storeCell(this.fundsCreated.toCell()).endCell();
        }
        if (this.magic == 10L) {
            return CellBuilder.beginCell().storeUint(11, 8).storeUint(this.seqNo, 32).storeUint(this.regMcSeqno, 32).storeUint(this.startLt, 64).storeUint(this.endLt, 64).storeUint(this.rootHash, 64).storeUint(this.fileHash, 64).storeBit(Boolean.valueOf(this.beforeSplit)).storeBit(Boolean.valueOf(this.beforeMerge)).storeBit(Boolean.valueOf(this.wantSplit)).storeBit(Boolean.valueOf(this.wantMerge)).storeBit(Boolean.valueOf(this.nXCCUpdated)).storeUint(this.flags, 3).storeUint(this.nextCatchainSeqNo, 32).storeUint(this.nextValidatorShard, 64).storeUint(this.minRefMcSeqNo, 32).storeUint(this.genUTime, 32).storeCell(this.splitMergeAt.toCell()).storeRef(CellBuilder.beginCell().storeCell(this.feesCollected.toCell()).storeCell(this.fundsCreated.toCell()).endCell()).endCell();
        }
        throw new Error("ShardDescr: magic neither equal to 0xA nor 0xB, found 0x" + Long.toHexString(this.magic));
    }

    public static ShardDescr deserialize(CellSlice cs) {
        long magic = cs.loadUint(8).intValue();
        if (magic == 11L) {
            return ShardDescr.builder().magic(11L).seqNo(cs.loadUint(32).longValue()).regMcSeqno(cs.loadUint(32).longValue()).startLt(cs.loadUint(64)).endLt(cs.loadUint(64)).rootHash(cs.loadUint(64)).fileHash(cs.loadUint(64)).beforeSplit(cs.loadBit()).beforeMerge(cs.loadBit()).wantSplit(cs.loadBit()).wantMerge(cs.loadBit()).nXCCUpdated(cs.loadBit()).flags(cs.loadUint(3).intValue()).nextCatchainSeqNo(cs.loadUint(32).longValue()).nextValidatorShard(cs.loadUint(64)).minRefMcSeqNo(cs.loadUint(32).longValue()).genUTime(cs.loadUint(32).longValue()).splitMergeAt(FutureSplitMerge.deserialize(cs)).feesCollected(CurrencyCollection.deserialize(cs)).fundsCreated(CurrencyCollection.deserialize(cs)).build();
        }
        if (magic == 10L) {
            return ShardDescr.builder().magic(11L).seqNo(cs.loadUint(32).longValue()).regMcSeqno(cs.loadUint(32).longValue()).startLt(cs.loadUint(64)).endLt(cs.loadUint(64)).rootHash(cs.loadUint(64)).fileHash(cs.loadUint(64)).beforeSplit(cs.loadBit()).beforeMerge(cs.loadBit()).wantSplit(cs.loadBit()).wantMerge(cs.loadBit()).nXCCUpdated(cs.loadBit()).flags(cs.loadUint(3).intValue()).nextCatchainSeqNo(cs.loadUint(32).longValue()).nextValidatorShard(cs.loadUint(64)).minRefMcSeqNo(cs.loadUint(32).longValue()).genUTime(cs.loadUint(32).longValue()).splitMergeAt(FutureSplitMerge.deserialize(cs)).refInfoA(cs.loadRef()).build();
        }
        throw new Error("ShardDescr: magic neither equal to 0xA nor 0xB, found 0x" + Long.toHexString(magic));
    }

    ShardDescr(long magic, long seqNo, long regMcSeqno, BigInteger startLt, BigInteger endLt, BigInteger rootHash, BigInteger fileHash, boolean beforeSplit, boolean beforeMerge, boolean wantSplit, boolean wantMerge, boolean nXCCUpdated, int flags, long nextCatchainSeqNo, BigInteger nextValidatorShard, long minRefMcSeqNo, long genUTime, FutureSplitMerge splitMergeAt, CurrencyCollection feesCollected, CurrencyCollection fundsCreated, Cell refInfoA) {
        this.magic = magic;
        this.seqNo = seqNo;
        this.regMcSeqno = regMcSeqno;
        this.startLt = startLt;
        this.endLt = endLt;
        this.rootHash = rootHash;
        this.fileHash = fileHash;
        this.beforeSplit = beforeSplit;
        this.beforeMerge = beforeMerge;
        this.wantSplit = wantSplit;
        this.wantMerge = wantMerge;
        this.nXCCUpdated = nXCCUpdated;
        this.flags = flags;
        this.nextCatchainSeqNo = nextCatchainSeqNo;
        this.nextValidatorShard = nextValidatorShard;
        this.minRefMcSeqNo = minRefMcSeqNo;
        this.genUTime = genUTime;
        this.splitMergeAt = splitMergeAt;
        this.feesCollected = feesCollected;
        this.fundsCreated = fundsCreated;
        this.refInfoA = refInfoA;
    }

    public static ShardDescrBuilder builder() {
        return new ShardDescrBuilder();
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getRegMcSeqno() {
        return this.regMcSeqno;
    }

    public BigInteger getStartLt() {
        return this.startLt;
    }

    public BigInteger getEndLt() {
        return this.endLt;
    }

    public boolean isBeforeSplit() {
        return this.beforeSplit;
    }

    public boolean isBeforeMerge() {
        return this.beforeMerge;
    }

    public boolean isWantSplit() {
        return this.wantSplit;
    }

    public boolean isWantMerge() {
        return this.wantMerge;
    }

    public boolean isNXCCUpdated() {
        return this.nXCCUpdated;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getNextCatchainSeqNo() {
        return this.nextCatchainSeqNo;
    }

    public BigInteger getNextValidatorShard() {
        return this.nextValidatorShard;
    }

    public long getMinRefMcSeqNo() {
        return this.minRefMcSeqNo;
    }

    public long getGenUTime() {
        return this.genUTime;
    }

    public FutureSplitMerge getSplitMergeAt() {
        return this.splitMergeAt;
    }

    public CurrencyCollection getFeesCollected() {
        return this.feesCollected;
    }

    public CurrencyCollection getFundsCreated() {
        return this.fundsCreated;
    }

    public Cell getRefInfoA() {
        return this.refInfoA;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    public void setRegMcSeqno(long regMcSeqno) {
        this.regMcSeqno = regMcSeqno;
    }

    public void setStartLt(BigInteger startLt) {
        this.startLt = startLt;
    }

    public void setEndLt(BigInteger endLt) {
        this.endLt = endLt;
    }

    public void setRootHash(BigInteger rootHash) {
        this.rootHash = rootHash;
    }

    public void setFileHash(BigInteger fileHash) {
        this.fileHash = fileHash;
    }

    public void setBeforeSplit(boolean beforeSplit) {
        this.beforeSplit = beforeSplit;
    }

    public void setBeforeMerge(boolean beforeMerge) {
        this.beforeMerge = beforeMerge;
    }

    public void setWantSplit(boolean wantSplit) {
        this.wantSplit = wantSplit;
    }

    public void setWantMerge(boolean wantMerge) {
        this.wantMerge = wantMerge;
    }

    public void setNXCCUpdated(boolean nXCCUpdated) {
        this.nXCCUpdated = nXCCUpdated;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setNextCatchainSeqNo(long nextCatchainSeqNo) {
        this.nextCatchainSeqNo = nextCatchainSeqNo;
    }

    public void setNextValidatorShard(BigInteger nextValidatorShard) {
        this.nextValidatorShard = nextValidatorShard;
    }

    public void setMinRefMcSeqNo(long minRefMcSeqNo) {
        this.minRefMcSeqNo = minRefMcSeqNo;
    }

    public void setGenUTime(long genUTime) {
        this.genUTime = genUTime;
    }

    public void setSplitMergeAt(FutureSplitMerge splitMergeAt) {
        this.splitMergeAt = splitMergeAt;
    }

    public void setFeesCollected(CurrencyCollection feesCollected) {
        this.feesCollected = feesCollected;
    }

    public void setFundsCreated(CurrencyCollection fundsCreated) {
        this.fundsCreated = fundsCreated;
    }

    public void setRefInfoA(Cell refInfoA) {
        this.refInfoA = refInfoA;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardDescr)) {
            return false;
        }
        ShardDescr other = (ShardDescr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getSeqNo() != other.getSeqNo()) {
            return false;
        }
        if (this.getRegMcSeqno() != other.getRegMcSeqno()) {
            return false;
        }
        if (this.isBeforeSplit() != other.isBeforeSplit()) {
            return false;
        }
        if (this.isBeforeMerge() != other.isBeforeMerge()) {
            return false;
        }
        if (this.isWantSplit() != other.isWantSplit()) {
            return false;
        }
        if (this.isWantMerge() != other.isWantMerge()) {
            return false;
        }
        if (this.isNXCCUpdated() != other.isNXCCUpdated()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.getNextCatchainSeqNo() != other.getNextCatchainSeqNo()) {
            return false;
        }
        if (this.getMinRefMcSeqNo() != other.getMinRefMcSeqNo()) {
            return false;
        }
        if (this.getGenUTime() != other.getGenUTime()) {
            return false;
        }
        BigInteger this$startLt = this.getStartLt();
        BigInteger other$startLt = other.getStartLt();
        if (this$startLt == null ? other$startLt != null : !((Object)this$startLt).equals(other$startLt)) {
            return false;
        }
        BigInteger this$endLt = this.getEndLt();
        BigInteger other$endLt = other.getEndLt();
        if (this$endLt == null ? other$endLt != null : !((Object)this$endLt).equals(other$endLt)) {
            return false;
        }
        String this$rootHash = this.getRootHash();
        String other$rootHash = other.getRootHash();
        if (this$rootHash == null ? other$rootHash != null : !this$rootHash.equals(other$rootHash)) {
            return false;
        }
        String this$fileHash = this.getFileHash();
        String other$fileHash = other.getFileHash();
        if (this$fileHash == null ? other$fileHash != null : !this$fileHash.equals(other$fileHash)) {
            return false;
        }
        BigInteger this$nextValidatorShard = this.getNextValidatorShard();
        BigInteger other$nextValidatorShard = other.getNextValidatorShard();
        if (this$nextValidatorShard == null ? other$nextValidatorShard != null : !((Object)this$nextValidatorShard).equals(other$nextValidatorShard)) {
            return false;
        }
        FutureSplitMerge this$splitMergeAt = this.getSplitMergeAt();
        FutureSplitMerge other$splitMergeAt = other.getSplitMergeAt();
        if (this$splitMergeAt == null ? other$splitMergeAt != null : !((Object)this$splitMergeAt).equals(other$splitMergeAt)) {
            return false;
        }
        CurrencyCollection this$feesCollected = this.getFeesCollected();
        CurrencyCollection other$feesCollected = other.getFeesCollected();
        if (this$feesCollected == null ? other$feesCollected != null : !((Object)this$feesCollected).equals(other$feesCollected)) {
            return false;
        }
        CurrencyCollection this$fundsCreated = this.getFundsCreated();
        CurrencyCollection other$fundsCreated = other.getFundsCreated();
        if (this$fundsCreated == null ? other$fundsCreated != null : !((Object)this$fundsCreated).equals(other$fundsCreated)) {
            return false;
        }
        Cell this$refInfoA = this.getRefInfoA();
        Cell other$refInfoA = other.getRefInfoA();
        return !(this$refInfoA == null ? other$refInfoA != null : !this$refInfoA.equals(other$refInfoA));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardDescr;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        long $seqNo = this.getSeqNo();
        result = result * 59 + (int)($seqNo >>> 32 ^ $seqNo);
        long $regMcSeqno = this.getRegMcSeqno();
        result = result * 59 + (int)($regMcSeqno >>> 32 ^ $regMcSeqno);
        result = result * 59 + (this.isBeforeSplit() ? 79 : 97);
        result = result * 59 + (this.isBeforeMerge() ? 79 : 97);
        result = result * 59 + (this.isWantSplit() ? 79 : 97);
        result = result * 59 + (this.isWantMerge() ? 79 : 97);
        result = result * 59 + (this.isNXCCUpdated() ? 79 : 97);
        result = result * 59 + this.getFlags();
        long $nextCatchainSeqNo = this.getNextCatchainSeqNo();
        result = result * 59 + (int)($nextCatchainSeqNo >>> 32 ^ $nextCatchainSeqNo);
        long $minRefMcSeqNo = this.getMinRefMcSeqNo();
        result = result * 59 + (int)($minRefMcSeqNo >>> 32 ^ $minRefMcSeqNo);
        long $genUTime = this.getGenUTime();
        result = result * 59 + (int)($genUTime >>> 32 ^ $genUTime);
        BigInteger $startLt = this.getStartLt();
        result = result * 59 + ($startLt == null ? 43 : ((Object)$startLt).hashCode());
        BigInteger $endLt = this.getEndLt();
        result = result * 59 + ($endLt == null ? 43 : ((Object)$endLt).hashCode());
        String $rootHash = this.getRootHash();
        result = result * 59 + ($rootHash == null ? 43 : $rootHash.hashCode());
        String $fileHash = this.getFileHash();
        result = result * 59 + ($fileHash == null ? 43 : $fileHash.hashCode());
        BigInteger $nextValidatorShard = this.getNextValidatorShard();
        result = result * 59 + ($nextValidatorShard == null ? 43 : ((Object)$nextValidatorShard).hashCode());
        FutureSplitMerge $splitMergeAt = this.getSplitMergeAt();
        result = result * 59 + ($splitMergeAt == null ? 43 : ((Object)$splitMergeAt).hashCode());
        CurrencyCollection $feesCollected = this.getFeesCollected();
        result = result * 59 + ($feesCollected == null ? 43 : ((Object)$feesCollected).hashCode());
        CurrencyCollection $fundsCreated = this.getFundsCreated();
        result = result * 59 + ($fundsCreated == null ? 43 : ((Object)$fundsCreated).hashCode());
        Cell $refInfoA = this.getRefInfoA();
        result = result * 59 + ($refInfoA == null ? 43 : $refInfoA.hashCode());
        return result;
    }

    public String toString() {
        return "ShardDescr(magic=" + this.getMagic() + ", seqNo=" + this.getSeqNo() + ", regMcSeqno=" + this.getRegMcSeqno() + ", startLt=" + String.valueOf(this.getStartLt()) + ", endLt=" + String.valueOf(this.getEndLt()) + ", rootHash=" + this.getRootHash() + ", fileHash=" + this.getFileHash() + ", beforeSplit=" + this.isBeforeSplit() + ", beforeMerge=" + this.isBeforeMerge() + ", wantSplit=" + this.isWantSplit() + ", wantMerge=" + this.isWantMerge() + ", nXCCUpdated=" + this.isNXCCUpdated() + ", flags=" + this.getFlags() + ", nextCatchainSeqNo=" + this.getNextCatchainSeqNo() + ", nextValidatorShard=" + String.valueOf(this.getNextValidatorShard()) + ", minRefMcSeqNo=" + this.getMinRefMcSeqNo() + ", genUTime=" + this.getGenUTime() + ", splitMergeAt=" + String.valueOf(this.getSplitMergeAt()) + ", feesCollected=" + String.valueOf(this.getFeesCollected()) + ", fundsCreated=" + String.valueOf(this.getFundsCreated()) + ", refInfoA=" + String.valueOf(this.getRefInfoA()) + ")";
    }

    public static class ShardDescrBuilder {
        private long magic;
        private long seqNo;
        private long regMcSeqno;
        private BigInteger startLt;
        private BigInteger endLt;
        private BigInteger rootHash;
        private BigInteger fileHash;
        private boolean beforeSplit;
        private boolean beforeMerge;
        private boolean wantSplit;
        private boolean wantMerge;
        private boolean nXCCUpdated;
        private int flags;
        private long nextCatchainSeqNo;
        private BigInteger nextValidatorShard;
        private long minRefMcSeqNo;
        private long genUTime;
        private FutureSplitMerge splitMergeAt;
        private CurrencyCollection feesCollected;
        private CurrencyCollection fundsCreated;
        private Cell refInfoA;

        ShardDescrBuilder() {
        }

        public ShardDescrBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ShardDescrBuilder seqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        public ShardDescrBuilder regMcSeqno(long regMcSeqno) {
            this.regMcSeqno = regMcSeqno;
            return this;
        }

        public ShardDescrBuilder startLt(BigInteger startLt) {
            this.startLt = startLt;
            return this;
        }

        public ShardDescrBuilder endLt(BigInteger endLt) {
            this.endLt = endLt;
            return this;
        }

        public ShardDescrBuilder rootHash(BigInteger rootHash) {
            this.rootHash = rootHash;
            return this;
        }

        public ShardDescrBuilder fileHash(BigInteger fileHash) {
            this.fileHash = fileHash;
            return this;
        }

        public ShardDescrBuilder beforeSplit(boolean beforeSplit) {
            this.beforeSplit = beforeSplit;
            return this;
        }

        public ShardDescrBuilder beforeMerge(boolean beforeMerge) {
            this.beforeMerge = beforeMerge;
            return this;
        }

        public ShardDescrBuilder wantSplit(boolean wantSplit) {
            this.wantSplit = wantSplit;
            return this;
        }

        public ShardDescrBuilder wantMerge(boolean wantMerge) {
            this.wantMerge = wantMerge;
            return this;
        }

        public ShardDescrBuilder nXCCUpdated(boolean nXCCUpdated) {
            this.nXCCUpdated = nXCCUpdated;
            return this;
        }

        public ShardDescrBuilder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public ShardDescrBuilder nextCatchainSeqNo(long nextCatchainSeqNo) {
            this.nextCatchainSeqNo = nextCatchainSeqNo;
            return this;
        }

        public ShardDescrBuilder nextValidatorShard(BigInteger nextValidatorShard) {
            this.nextValidatorShard = nextValidatorShard;
            return this;
        }

        public ShardDescrBuilder minRefMcSeqNo(long minRefMcSeqNo) {
            this.minRefMcSeqNo = minRefMcSeqNo;
            return this;
        }

        public ShardDescrBuilder genUTime(long genUTime) {
            this.genUTime = genUTime;
            return this;
        }

        public ShardDescrBuilder splitMergeAt(FutureSplitMerge splitMergeAt) {
            this.splitMergeAt = splitMergeAt;
            return this;
        }

        public ShardDescrBuilder feesCollected(CurrencyCollection feesCollected) {
            this.feesCollected = feesCollected;
            return this;
        }

        public ShardDescrBuilder fundsCreated(CurrencyCollection fundsCreated) {
            this.fundsCreated = fundsCreated;
            return this;
        }

        public ShardDescrBuilder refInfoA(Cell refInfoA) {
            this.refInfoA = refInfoA;
            return this;
        }

        public ShardDescr build() {
            return new ShardDescr(this.magic, this.seqNo, this.regMcSeqno, this.startLt, this.endLt, this.rootHash, this.fileHash, this.beforeSplit, this.beforeMerge, this.wantSplit, this.wantMerge, this.nXCCUpdated, this.flags, this.nextCatchainSeqNo, this.nextValidatorShard, this.minRefMcSeqNo, this.genUTime, this.splitMergeAt, this.feesCollected, this.fundsCreated, this.refInfoA);
        }

        public String toString() {
            return "ShardDescr.ShardDescrBuilder(magic=" + this.magic + ", seqNo=" + this.seqNo + ", regMcSeqno=" + this.regMcSeqno + ", startLt=" + String.valueOf(this.startLt) + ", endLt=" + String.valueOf(this.endLt) + ", rootHash=" + String.valueOf(this.rootHash) + ", fileHash=" + String.valueOf(this.fileHash) + ", beforeSplit=" + this.beforeSplit + ", beforeMerge=" + this.beforeMerge + ", wantSplit=" + this.wantSplit + ", wantMerge=" + this.wantMerge + ", nXCCUpdated=" + this.nXCCUpdated + ", flags=" + this.flags + ", nextCatchainSeqNo=" + this.nextCatchainSeqNo + ", nextValidatorShard=" + String.valueOf(this.nextValidatorShard) + ", minRefMcSeqNo=" + this.minRefMcSeqNo + ", genUTime=" + this.genUTime + ", splitMergeAt=" + String.valueOf(this.splitMergeAt) + ", feesCollected=" + String.valueOf(this.feesCollected) + ", fundsCreated=" + String.valueOf(this.fundsCreated) + ", refInfoA=" + String.valueOf(this.refInfoA) + ")";
        }
    }
}

