/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.Account;

public class ShardAccount
implements Serializable {
    Account account;
    BigInteger lastTransHash;
    BigInteger lastTransLt;

    public Cell toCell() {
        return CellBuilder.beginCell().storeRef(this.account.toCell()).storeUint(this.lastTransHash, 256).storeUint(this.lastTransLt, 64).endCell();
    }

    public static ShardAccount deserialize(CellSlice cs) {
        return ShardAccount.builder().account(Account.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).lastTransHash(cs.loadUint(256)).lastTransLt(cs.loadUint(64)).build();
    }

    public BigInteger getBalance() {
        return this.account.getAccountStorage().getBalance().getCoins();
    }

    ShardAccount(Account account, BigInteger lastTransHash, BigInteger lastTransLt) {
        this.account = account;
        this.lastTransHash = lastTransHash;
        this.lastTransLt = lastTransLt;
    }

    public static ShardAccountBuilder builder() {
        return new ShardAccountBuilder();
    }

    public Account getAccount() {
        return this.account;
    }

    public BigInteger getLastTransHash() {
        return this.lastTransHash;
    }

    public BigInteger getLastTransLt() {
        return this.lastTransLt;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setLastTransHash(BigInteger lastTransHash) {
        this.lastTransHash = lastTransHash;
    }

    public void setLastTransLt(BigInteger lastTransLt) {
        this.lastTransLt = lastTransLt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardAccount)) {
            return false;
        }
        ShardAccount other = (ShardAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Account this$account = this.getAccount();
        Account other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        BigInteger this$lastTransHash = this.getLastTransHash();
        BigInteger other$lastTransHash = other.getLastTransHash();
        if (this$lastTransHash == null ? other$lastTransHash != null : !((Object)this$lastTransHash).equals(other$lastTransHash)) {
            return false;
        }
        BigInteger this$lastTransLt = this.getLastTransLt();
        BigInteger other$lastTransLt = other.getLastTransLt();
        return !(this$lastTransLt == null ? other$lastTransLt != null : !((Object)this$lastTransLt).equals(other$lastTransLt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Account $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        BigInteger $lastTransHash = this.getLastTransHash();
        result = result * 59 + ($lastTransHash == null ? 43 : ((Object)$lastTransHash).hashCode());
        BigInteger $lastTransLt = this.getLastTransLt();
        result = result * 59 + ($lastTransLt == null ? 43 : ((Object)$lastTransLt).hashCode());
        return result;
    }

    public String toString() {
        return "ShardAccount(account=" + String.valueOf(this.getAccount()) + ", lastTransHash=" + String.valueOf(this.getLastTransHash()) + ", lastTransLt=" + String.valueOf(this.getLastTransLt()) + ")";
    }

    public static class ShardAccountBuilder {
        private Account account;
        private BigInteger lastTransHash;
        private BigInteger lastTransLt;

        ShardAccountBuilder() {
        }

        public ShardAccountBuilder account(Account account) {
            this.account = account;
            return this;
        }

        public ShardAccountBuilder lastTransHash(BigInteger lastTransHash) {
            this.lastTransHash = lastTransHash;
            return this;
        }

        public ShardAccountBuilder lastTransLt(BigInteger lastTransLt) {
            this.lastTransLt = lastTransLt;
            return this;
        }

        public ShardAccount build() {
            return new ShardAccount(this.account, this.lastTransHash, this.lastTransLt);
        }

        public String toString() {
            return "ShardAccount.ShardAccountBuilder(account=" + String.valueOf(this.account) + ", lastTransHash=" + String.valueOf(this.lastTransHash) + ", lastTransLt=" + String.valueOf(this.lastTransLt) + ")";
        }
    }
}

