/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;

public class OracleBridgeParams
implements Serializable {
    BigInteger bridgeAddress;
    BigInteger oracleMultiSigAddress;
    TonHashMapE oracles;
    BigInteger externalChainAddress;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.bridgeAddress, 256).storeUint(this.oracleMultiSigAddress, 256).storeDict(this.oracles.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 256).endCell().getBits(), v -> CellBuilder.beginCell().storeUint((BigInteger)v, 256).endCell())).storeUint(this.externalChainAddress, 256).endCell();
    }

    public static OracleBridgeParams deserialize(CellSlice cs) {
        return OracleBridgeParams.builder().bridgeAddress(cs.loadUint(256)).oracleMultiSigAddress(cs.loadUint(256)).oracles(cs.loadDictE(256, k -> k.readUint(256), v -> CellSlice.beginParse((Cell)v).loadUint(256))).build();
    }

    OracleBridgeParams(BigInteger bridgeAddress, BigInteger oracleMultiSigAddress, TonHashMapE oracles, BigInteger externalChainAddress) {
        this.bridgeAddress = bridgeAddress;
        this.oracleMultiSigAddress = oracleMultiSigAddress;
        this.oracles = oracles;
        this.externalChainAddress = externalChainAddress;
    }

    public static OracleBridgeParamsBuilder builder() {
        return new OracleBridgeParamsBuilder();
    }

    public BigInteger getBridgeAddress() {
        return this.bridgeAddress;
    }

    public BigInteger getOracleMultiSigAddress() {
        return this.oracleMultiSigAddress;
    }

    public TonHashMapE getOracles() {
        return this.oracles;
    }

    public BigInteger getExternalChainAddress() {
        return this.externalChainAddress;
    }

    public void setBridgeAddress(BigInteger bridgeAddress) {
        this.bridgeAddress = bridgeAddress;
    }

    public void setOracleMultiSigAddress(BigInteger oracleMultiSigAddress) {
        this.oracleMultiSigAddress = oracleMultiSigAddress;
    }

    public void setOracles(TonHashMapE oracles) {
        this.oracles = oracles;
    }

    public void setExternalChainAddress(BigInteger externalChainAddress) {
        this.externalChainAddress = externalChainAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OracleBridgeParams)) {
            return false;
        }
        OracleBridgeParams other = (OracleBridgeParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$bridgeAddress = this.getBridgeAddress();
        BigInteger other$bridgeAddress = other.getBridgeAddress();
        if (this$bridgeAddress == null ? other$bridgeAddress != null : !((Object)this$bridgeAddress).equals(other$bridgeAddress)) {
            return false;
        }
        BigInteger this$oracleMultiSigAddress = this.getOracleMultiSigAddress();
        BigInteger other$oracleMultiSigAddress = other.getOracleMultiSigAddress();
        if (this$oracleMultiSigAddress == null ? other$oracleMultiSigAddress != null : !((Object)this$oracleMultiSigAddress).equals(other$oracleMultiSigAddress)) {
            return false;
        }
        TonHashMapE this$oracles = this.getOracles();
        TonHashMapE other$oracles = other.getOracles();
        if (this$oracles == null ? other$oracles != null : !this$oracles.equals(other$oracles)) {
            return false;
        }
        BigInteger this$externalChainAddress = this.getExternalChainAddress();
        BigInteger other$externalChainAddress = other.getExternalChainAddress();
        return !(this$externalChainAddress == null ? other$externalChainAddress != null : !((Object)this$externalChainAddress).equals(other$externalChainAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OracleBridgeParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $bridgeAddress = this.getBridgeAddress();
        result = result * 59 + ($bridgeAddress == null ? 43 : ((Object)$bridgeAddress).hashCode());
        BigInteger $oracleMultiSigAddress = this.getOracleMultiSigAddress();
        result = result * 59 + ($oracleMultiSigAddress == null ? 43 : ((Object)$oracleMultiSigAddress).hashCode());
        TonHashMapE $oracles = this.getOracles();
        result = result * 59 + ($oracles == null ? 43 : $oracles.hashCode());
        BigInteger $externalChainAddress = this.getExternalChainAddress();
        result = result * 59 + ($externalChainAddress == null ? 43 : ((Object)$externalChainAddress).hashCode());
        return result;
    }

    public String toString() {
        return "OracleBridgeParams(bridgeAddress=" + String.valueOf(this.getBridgeAddress()) + ", oracleMultiSigAddress=" + String.valueOf(this.getOracleMultiSigAddress()) + ", oracles=" + String.valueOf(this.getOracles()) + ", externalChainAddress=" + String.valueOf(this.getExternalChainAddress()) + ")";
    }

    public static class OracleBridgeParamsBuilder {
        private BigInteger bridgeAddress;
        private BigInteger oracleMultiSigAddress;
        private TonHashMapE oracles;
        private BigInteger externalChainAddress;

        OracleBridgeParamsBuilder() {
        }

        public OracleBridgeParamsBuilder bridgeAddress(BigInteger bridgeAddress) {
            this.bridgeAddress = bridgeAddress;
            return this;
        }

        public OracleBridgeParamsBuilder oracleMultiSigAddress(BigInteger oracleMultiSigAddress) {
            this.oracleMultiSigAddress = oracleMultiSigAddress;
            return this;
        }

        public OracleBridgeParamsBuilder oracles(TonHashMapE oracles) {
            this.oracles = oracles;
            return this;
        }

        public OracleBridgeParamsBuilder externalChainAddress(BigInteger externalChainAddress) {
            this.externalChainAddress = externalChainAddress;
            return this;
        }

        public OracleBridgeParams build() {
            return new OracleBridgeParams(this.bridgeAddress, this.oracleMultiSigAddress, this.oracles, this.externalChainAddress);
        }

        public String toString() {
            return "OracleBridgeParams.OracleBridgeParamsBuilder(bridgeAddress=" + String.valueOf(this.bridgeAddress) + ", oracleMultiSigAddress=" + String.valueOf(this.oracleMultiSigAddress) + ", oracles=" + String.valueOf(this.oracles) + ", externalChainAddress=" + String.valueOf(this.externalChainAddress) + ")";
        }
    }
}

