/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.Anycast;
import org.ton.java.tlb.MsgAddressInt;

public class MsgAddressIntStd
implements MsgAddressInt,
Serializable {
    int magic;
    Anycast anycast;
    byte workchainId;
    BigInteger address;

    public String toString() {
        String addressStr = this.address.toString(16);
        if (addressStr.length() != 64) {
            addressStr = StringUtils.leftPad((String)addressStr, (int)64, (String)"0");
        }
        return Objects.nonNull(this.address) ? this.workchainId + ":" + addressStr : null;
    }

    @Override
    public Cell toCell() {
        CellBuilder result = CellBuilder.beginCell();
        result.storeUint(2, 2);
        if (Objects.isNull(this.anycast)) {
            result.storeBit(Boolean.valueOf(false));
        } else {
            result.storeBit(Boolean.valueOf(true));
            result.storeCell(this.anycast.toCell());
        }
        result.storeInt(this.workchainId, 8);
        result.storeUint(this.address, 256);
        return result.endCell();
    }

    public static MsgAddressIntStd deserialize(CellSlice cs) {
        int magic = cs.loadUint(2).intValue();
        assert (magic == 2) : "MsgAddressIntStd: magic not equal to 0b10, found " + magic;
        Anycast anycast = null;
        if (cs.loadBit()) {
            anycast = Anycast.deserialize(cs);
        }
        return MsgAddressIntStd.builder().magic(magic).anycast(anycast).workchainId(cs.loadInt(8).byteValue()).address(cs.loadUint(256)).build();
    }

    @Override
    public Address toAddress() {
        return Address.of((String)this.toString());
    }

    public static MsgAddressIntStd of(String address) {
        Address addr = new Address(address);
        return MsgAddressIntStd.builder().workchainId(addr.wc).address(addr.toBigInteger()).anycast(null).build();
    }

    public static MsgAddressIntStd of(Address address) {
        return MsgAddressIntStd.builder().workchainId(address.wc).address(address.toBigInteger()).anycast(null).build();
    }

    MsgAddressIntStd(int magic, Anycast anycast, byte workchainId, BigInteger address) {
        this.magic = magic;
        this.anycast = anycast;
        this.workchainId = workchainId;
        this.address = address;
    }

    public static MsgAddressIntStdBuilder builder() {
        return new MsgAddressIntStdBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public Anycast getAnycast() {
        return this.anycast;
    }

    public byte getWorkchainId() {
        return this.workchainId;
    }

    public BigInteger getAddress() {
        return this.address;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setAnycast(Anycast anycast) {
        this.anycast = anycast;
    }

    public void setWorkchainId(byte workchainId) {
        this.workchainId = workchainId;
    }

    public void setAddress(BigInteger address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsgAddressIntStd)) {
            return false;
        }
        MsgAddressIntStd other = (MsgAddressIntStd)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getWorkchainId() != other.getWorkchainId()) {
            return false;
        }
        Anycast this$anycast = this.getAnycast();
        Anycast other$anycast = other.getAnycast();
        if (this$anycast == null ? other$anycast != null : !((Object)this$anycast).equals(other$anycast)) {
            return false;
        }
        BigInteger this$address = this.getAddress();
        BigInteger other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MsgAddressIntStd;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getWorkchainId();
        Anycast $anycast = this.getAnycast();
        result = result * 59 + ($anycast == null ? 43 : ((Object)$anycast).hashCode());
        BigInteger $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public static class MsgAddressIntStdBuilder {
        private int magic;
        private Anycast anycast;
        private byte workchainId;
        private BigInteger address;

        MsgAddressIntStdBuilder() {
        }

        public MsgAddressIntStdBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public MsgAddressIntStdBuilder anycast(Anycast anycast) {
            this.anycast = anycast;
            return this;
        }

        public MsgAddressIntStdBuilder workchainId(byte workchainId) {
            this.workchainId = workchainId;
            return this;
        }

        public MsgAddressIntStdBuilder address(BigInteger address) {
            this.address = address;
            return this;
        }

        public MsgAddressIntStd build() {
            return new MsgAddressIntStd(this.magic, this.anycast, this.workchainId, this.address);
        }

        public String toString() {
            return "MsgAddressIntStd.MsgAddressIntStdBuilder(magic=" + this.magic + ", anycast=" + String.valueOf(this.anycast) + ", workchainId=" + this.workchainId + ", address=" + String.valueOf(this.address) + ")";
        }
    }
}

