/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.MsgAddress;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tlb.MsgAddressIntVar;

public interface MsgAddressInt
extends MsgAddress {
    @Override
    public Cell toCell();

    public Address toAddress();

    public static MsgAddressInt deserialize(CellSlice cs) {
        int magic = cs.preloadUint(2).intValue();
        switch (magic) {
            case 2: {
                return MsgAddressIntStd.deserialize(cs);
            }
            case 3: {
                return MsgAddressIntVar.deserialize(cs);
            }
        }
        throw new Error("Wrong magic for MsgAddressInt, found " + magic);
    }
}

