/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.MsgAddressExtNone;
import org.ton.java.tlb.MsgAddressExternal;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tlb.MsgAddressIntVar;

public interface MsgAddress {
    public Cell toCell();

    public static MsgAddress deserialize(CellSlice cs) {
        int magic = cs.preloadUint(2).intValue();
        switch (magic) {
            case 0: {
                cs.loadInt(2);
                return MsgAddressExtNone.builder().build();
            }
            case 1: {
                return MsgAddressExternal.deserialize(cs);
            }
            case 2: {
                return MsgAddressIntStd.deserialize(cs);
            }
            case 3: {
                return MsgAddressIntVar.deserialize(cs);
            }
        }
        throw new Error("Wrong magic for MsgAddress");
    }
}

