/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CommonMsgInfoRelaxed;
import org.ton.java.tlb.StateInit;

public class MessageRelaxed {
    CommonMsgInfoRelaxed info;
    StateInit init;
    Cell body;

    public Cell toCell() {
        CellBuilder c = CellBuilder.beginCell();
        c.storeCell(this.info.toCell());
        if (Objects.isNull(this.init)) {
            c.storeBit(Boolean.valueOf(false));
        } else {
            c.storeBit(Boolean.valueOf(true));
            Cell initCell = this.init.toCell();
            if (c.getFreeBits() - 2 >= initCell.getBits().getUsedBits() + (Objects.nonNull(this.body) ? this.body.getBits().getUsedBits() : 0)) {
                c.storeBit(Boolean.valueOf(false));
                c.storeCell(initCell);
            } else {
                c.storeBit(Boolean.valueOf(true));
                c.storeRef(initCell);
            }
        }
        if (Objects.isNull(this.body)) {
            c.storeBit(Boolean.valueOf(false));
        } else if (c.getFreeBits() >= this.body.getBits().getUsedBits() && c.getFreeRefs() >= this.body.getUsedRefs()) {
            c.storeBit(Boolean.valueOf(false));
            c.storeCell(this.body);
        } else {
            c.storeBit(Boolean.valueOf(true));
            c.storeRef(this.body);
        }
        return c.endCell();
    }

    public static MessageRelaxed deserialize(CellSlice cs) {
        Cell body;
        MessageRelaxed message = MessageRelaxed.builder().info(CommonMsgInfoRelaxed.deserialize(cs)).build();
        StateInit stateInit = null;
        if (cs.loadBit()) {
            stateInit = cs.loadBit() ? StateInit.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : StateInit.deserialize(cs);
        }
        message.setInit(stateInit);
        if (cs.loadBit()) {
            body = cs.loadRef();
        } else {
            body = cs.sliceToCell();
            cs.loadBits(cs.getRestBits());
        }
        message.setBody(body);
        return message;
    }

    MessageRelaxed(CommonMsgInfoRelaxed info, StateInit init, Cell body) {
        this.info = info;
        this.init = init;
        this.body = body;
    }

    public static MessageRelaxedBuilder builder() {
        return new MessageRelaxedBuilder();
    }

    public CommonMsgInfoRelaxed getInfo() {
        return this.info;
    }

    public StateInit getInit() {
        return this.init;
    }

    public Cell getBody() {
        return this.body;
    }

    public void setInfo(CommonMsgInfoRelaxed info) {
        this.info = info;
    }

    public void setInit(StateInit init) {
        this.init = init;
    }

    public void setBody(Cell body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageRelaxed)) {
            return false;
        }
        MessageRelaxed other = (MessageRelaxed)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommonMsgInfoRelaxed this$info = this.getInfo();
        CommonMsgInfoRelaxed other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        StateInit this$init = this.getInit();
        StateInit other$init = other.getInit();
        if (this$init == null ? other$init != null : !((Object)this$init).equals(other$init)) {
            return false;
        }
        Cell this$body = this.getBody();
        Cell other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageRelaxed;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommonMsgInfoRelaxed $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        StateInit $init = this.getInit();
        result = result * 59 + ($init == null ? 43 : ((Object)$init).hashCode());
        Cell $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "MessageRelaxed(info=" + String.valueOf(this.getInfo()) + ", init=" + String.valueOf(this.getInit()) + ", body=" + String.valueOf(this.getBody()) + ")";
    }

    public static class MessageRelaxedBuilder {
        private CommonMsgInfoRelaxed info;
        private StateInit init;
        private Cell body;

        MessageRelaxedBuilder() {
        }

        public MessageRelaxedBuilder info(CommonMsgInfoRelaxed info) {
            this.info = info;
            return this;
        }

        public MessageRelaxedBuilder init(StateInit init) {
            this.init = init;
            return this;
        }

        public MessageRelaxedBuilder body(Cell body) {
            this.body = body;
            return this;
        }

        public MessageRelaxed build() {
            return new MessageRelaxed(this.info, this.init, this.body);
        }

        public String toString() {
            return "MessageRelaxed.MessageRelaxedBuilder(info=" + String.valueOf(this.info) + ", init=" + String.valueOf(this.init) + ", body=" + String.valueOf(this.body) + ")";
        }
    }
}

