/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.StateInit;

public class Message
implements Serializable {
    CommonMsgInfo info;
    StateInit init;
    Cell body;

    public Cell toCell() {
        CellBuilder c = CellBuilder.beginCell();
        c.storeCell(this.info.toCell());
        if (Objects.isNull(this.init)) {
            c.storeBit(Boolean.valueOf(false));
        } else {
            c.storeBit(Boolean.valueOf(true));
            Cell initCell = this.init.toCell();
            if (c.getFreeBits() - 2 >= initCell.getBits().getUsedBits() + (Objects.nonNull(this.body) ? this.body.getBits().getUsedBits() : 0)) {
                c.storeBit(Boolean.valueOf(false));
                c.storeCell(initCell);
            } else {
                c.storeBit(Boolean.valueOf(true));
                c.storeRef(initCell);
            }
        }
        if (Objects.isNull(this.body)) {
            c.storeBit(Boolean.valueOf(false));
        } else if (c.getFreeBits() >= this.body.getBits().getUsedBits() && c.getFreeRefs() >= this.body.getUsedRefs()) {
            c.storeBit(Boolean.valueOf(false));
            c.storeCell(this.body);
        } else {
            c.storeBit(Boolean.valueOf(true));
            c.storeRef(this.body);
        }
        return c.endCell();
    }

    public static Message deserialize(CellSlice cs) {
        Cell body;
        Message message = Message.builder().info(CommonMsgInfo.deserialize(cs)).build();
        StateInit stateInit = null;
        if (cs.loadBit()) {
            stateInit = cs.loadBit() ? StateInit.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : StateInit.deserialize(cs);
        }
        message.setInit(stateInit);
        if (cs.loadBit()) {
            body = cs.loadRef();
        } else {
            body = cs.sliceToCell();
            cs.loadBits(cs.getRestBits());
        }
        message.setBody(body);
        return message;
    }

    public byte[] getNormalizedHash() {
        return CellBuilder.beginCell().storeUint(2, 2).storeAddress(null).storeAddress(Address.of((String)this.info.getDestinationAddress())).storeCoins(BigInteger.ZERO).storeBit(Boolean.valueOf(false)).storeBit(Boolean.valueOf(true)).storeRef(Objects.isNull(this.body) ? CellBuilder.beginCell().endCell() : CellBuilder.beginCell().storeCell(this.body).endCell()).endCell().getHash();
    }

    Message(CommonMsgInfo info, StateInit init, Cell body) {
        this.info = info;
        this.init = init;
        this.body = body;
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public CommonMsgInfo getInfo() {
        return this.info;
    }

    public StateInit getInit() {
        return this.init;
    }

    public Cell getBody() {
        return this.body;
    }

    public void setInfo(CommonMsgInfo info) {
        this.info = info;
    }

    public void setInit(StateInit init) {
        this.init = init;
    }

    public void setBody(Cell body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommonMsgInfo this$info = this.getInfo();
        CommonMsgInfo other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        StateInit this$init = this.getInit();
        StateInit other$init = other.getInit();
        if (this$init == null ? other$init != null : !((Object)this$init).equals(other$init)) {
            return false;
        }
        Cell this$body = this.getBody();
        Cell other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommonMsgInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        StateInit $init = this.getInit();
        result = result * 59 + ($init == null ? 43 : ((Object)$init).hashCode());
        Cell $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "Message(info=" + String.valueOf(this.getInfo()) + ", init=" + String.valueOf(this.getInit()) + ", body=" + String.valueOf(this.getBody()) + ")";
    }

    public static class MessageBuilder {
        private CommonMsgInfo info;
        private StateInit init;
        private Cell body;

        MessageBuilder() {
        }

        public MessageBuilder info(CommonMsgInfo info) {
            this.info = info;
            return this;
        }

        public MessageBuilder init(StateInit init) {
            this.init = init;
            return this;
        }

        public MessageBuilder body(Cell body) {
            this.body = body;
            return this;
        }

        public Message build() {
            return new Message(this.info, this.init, this.body);
        }

        public String toString() {
            return "Message.MessageBuilder(info=" + String.valueOf(this.info) + ", init=" + String.valueOf(this.init) + ", body=" + String.valueOf(this.body) + ")";
        }
    }
}

