/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ConfigParams;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.McStateExtraInfo;
import org.ton.java.tlb.ShardHashes;

public class McStateExtra
implements Serializable {
    long magic;
    ShardHashes shardHashes;
    ConfigParams configParams;
    McStateExtraInfo info;
    CurrencyCollection globalBalance;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(52262, 16).storeCell(this.shardHashes.toCell()).storeCell(this.configParams.toCell()).storeRef(this.info.toCell()).storeCell(this.globalBalance.toCell()).endCell();
    }

    public static McStateExtra deserialize(CellSlice cs) {
        if (Objects.isNull(cs)) {
            return null;
        }
        if (cs.isExotic()) {
            return null;
        }
        long magic = cs.loadUint(16).longValue();
        assert (magic == 52262L) : "McStateExtra: magic not equal to 0xcc26, found 0x" + Long.toHexString(magic);
        McStateExtra mcStateExtra = McStateExtra.builder().magic(52262L).shardHashes(ShardHashes.deserialize(cs)).build();
        mcStateExtra.setConfigParams(ConfigParams.deserialize(cs));
        mcStateExtra.setInfo(McStateExtraInfo.deserialize(CellSlice.beginParse((Cell)cs.loadRef())));
        mcStateExtra.setGlobalBalance(CurrencyCollection.deserialize(cs));
        return mcStateExtra;
    }

    McStateExtra(long magic, ShardHashes shardHashes, ConfigParams configParams, McStateExtraInfo info, CurrencyCollection globalBalance) {
        this.magic = magic;
        this.shardHashes = shardHashes;
        this.configParams = configParams;
        this.info = info;
        this.globalBalance = globalBalance;
    }

    public static McStateExtraBuilder builder() {
        return new McStateExtraBuilder();
    }

    public ShardHashes getShardHashes() {
        return this.shardHashes;
    }

    public ConfigParams getConfigParams() {
        return this.configParams;
    }

    public McStateExtraInfo getInfo() {
        return this.info;
    }

    public CurrencyCollection getGlobalBalance() {
        return this.globalBalance;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setShardHashes(ShardHashes shardHashes) {
        this.shardHashes = shardHashes;
    }

    public void setConfigParams(ConfigParams configParams) {
        this.configParams = configParams;
    }

    public void setInfo(McStateExtraInfo info) {
        this.info = info;
    }

    public void setGlobalBalance(CurrencyCollection globalBalance) {
        this.globalBalance = globalBalance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McStateExtra)) {
            return false;
        }
        McStateExtra other = (McStateExtra)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        ShardHashes this$shardHashes = this.getShardHashes();
        ShardHashes other$shardHashes = other.getShardHashes();
        if (this$shardHashes == null ? other$shardHashes != null : !((Object)this$shardHashes).equals(other$shardHashes)) {
            return false;
        }
        ConfigParams this$configParams = this.getConfigParams();
        ConfigParams other$configParams = other.getConfigParams();
        if (this$configParams == null ? other$configParams != null : !((Object)this$configParams).equals(other$configParams)) {
            return false;
        }
        McStateExtraInfo this$info = this.getInfo();
        McStateExtraInfo other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        CurrencyCollection this$globalBalance = this.getGlobalBalance();
        CurrencyCollection other$globalBalance = other.getGlobalBalance();
        return !(this$globalBalance == null ? other$globalBalance != null : !((Object)this$globalBalance).equals(other$globalBalance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McStateExtra;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        ShardHashes $shardHashes = this.getShardHashes();
        result = result * 59 + ($shardHashes == null ? 43 : ((Object)$shardHashes).hashCode());
        ConfigParams $configParams = this.getConfigParams();
        result = result * 59 + ($configParams == null ? 43 : ((Object)$configParams).hashCode());
        McStateExtraInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        CurrencyCollection $globalBalance = this.getGlobalBalance();
        result = result * 59 + ($globalBalance == null ? 43 : ((Object)$globalBalance).hashCode());
        return result;
    }

    public String toString() {
        return "McStateExtra(magic=" + this.getMagic() + ", shardHashes=" + String.valueOf(this.getShardHashes()) + ", configParams=" + String.valueOf(this.getConfigParams()) + ", info=" + String.valueOf(this.getInfo()) + ", globalBalance=" + String.valueOf(this.getGlobalBalance()) + ")";
    }

    public static class McStateExtraBuilder {
        private long magic;
        private ShardHashes shardHashes;
        private ConfigParams configParams;
        private McStateExtraInfo info;
        private CurrencyCollection globalBalance;

        McStateExtraBuilder() {
        }

        public McStateExtraBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public McStateExtraBuilder shardHashes(ShardHashes shardHashes) {
            this.shardHashes = shardHashes;
            return this;
        }

        public McStateExtraBuilder configParams(ConfigParams configParams) {
            this.configParams = configParams;
            return this;
        }

        public McStateExtraBuilder info(McStateExtraInfo info) {
            this.info = info;
            return this;
        }

        public McStateExtraBuilder globalBalance(CurrencyCollection globalBalance) {
            this.globalBalance = globalBalance;
            return this;
        }

        public McStateExtra build() {
            return new McStateExtra(this.magic, this.shardHashes, this.configParams, this.info, this.globalBalance);
        }

        public String toString() {
            return "McStateExtra.McStateExtraBuilder(magic=" + this.magic + ", shardHashes=" + String.valueOf(this.shardHashes) + ", configParams=" + String.valueOf(this.configParams) + ", info=" + String.valueOf(this.info) + ", globalBalance=" + String.valueOf(this.globalBalance) + ")";
        }
    }
}

