/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.InMsg;

public class McBlockExtraInfo
implements Serializable {
    TonHashMapE prevBlkSignatures;
    InMsg recoverCreateMsg;
    InMsg mintMsg;

    public Cell toCell() {
        CellBuilder cell = CellBuilder.beginCell().storeDict(this.prevBlkSignatures.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 16).endCell().getBits(), v -> CellBuilder.beginCell().storeCell((Cell)v).endCell()));
        if (Objects.isNull(this.recoverCreateMsg)) {
            cell.storeBit(Boolean.valueOf(false));
        } else {
            cell.storeBit(Boolean.valueOf(true));
            cell.storeRef(this.recoverCreateMsg.toCell());
        }
        if (Objects.isNull(this.mintMsg)) {
            cell.storeBit(Boolean.valueOf(false));
        } else {
            cell.storeBit(Boolean.valueOf(true));
            cell.storeRef(this.mintMsg.toCell());
        }
        return cell.endCell();
    }

    public static McBlockExtraInfo deserialize(CellSlice cs) {
        return McBlockExtraInfo.builder().prevBlkSignatures(cs.loadDictE(16, k -> k.readInt(16), v -> v)).recoverCreateMsg(cs.loadBit() ? InMsg.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null).mintMsg(cs.loadBit() ? InMsg.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null).build();
    }

    McBlockExtraInfo(TonHashMapE prevBlkSignatures, InMsg recoverCreateMsg, InMsg mintMsg) {
        this.prevBlkSignatures = prevBlkSignatures;
        this.recoverCreateMsg = recoverCreateMsg;
        this.mintMsg = mintMsg;
    }

    public static McBlockExtraInfoBuilder builder() {
        return new McBlockExtraInfoBuilder();
    }

    public TonHashMapE getPrevBlkSignatures() {
        return this.prevBlkSignatures;
    }

    public InMsg getRecoverCreateMsg() {
        return this.recoverCreateMsg;
    }

    public InMsg getMintMsg() {
        return this.mintMsg;
    }

    public void setPrevBlkSignatures(TonHashMapE prevBlkSignatures) {
        this.prevBlkSignatures = prevBlkSignatures;
    }

    public void setRecoverCreateMsg(InMsg recoverCreateMsg) {
        this.recoverCreateMsg = recoverCreateMsg;
    }

    public void setMintMsg(InMsg mintMsg) {
        this.mintMsg = mintMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McBlockExtraInfo)) {
            return false;
        }
        McBlockExtraInfo other = (McBlockExtraInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TonHashMapE this$prevBlkSignatures = this.getPrevBlkSignatures();
        TonHashMapE other$prevBlkSignatures = other.getPrevBlkSignatures();
        if (this$prevBlkSignatures == null ? other$prevBlkSignatures != null : !this$prevBlkSignatures.equals(other$prevBlkSignatures)) {
            return false;
        }
        InMsg this$recoverCreateMsg = this.getRecoverCreateMsg();
        InMsg other$recoverCreateMsg = other.getRecoverCreateMsg();
        if (this$recoverCreateMsg == null ? other$recoverCreateMsg != null : !this$recoverCreateMsg.equals(other$recoverCreateMsg)) {
            return false;
        }
        InMsg this$mintMsg = this.getMintMsg();
        InMsg other$mintMsg = other.getMintMsg();
        return !(this$mintMsg == null ? other$mintMsg != null : !this$mintMsg.equals(other$mintMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McBlockExtraInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TonHashMapE $prevBlkSignatures = this.getPrevBlkSignatures();
        result = result * 59 + ($prevBlkSignatures == null ? 43 : $prevBlkSignatures.hashCode());
        InMsg $recoverCreateMsg = this.getRecoverCreateMsg();
        result = result * 59 + ($recoverCreateMsg == null ? 43 : $recoverCreateMsg.hashCode());
        InMsg $mintMsg = this.getMintMsg();
        result = result * 59 + ($mintMsg == null ? 43 : $mintMsg.hashCode());
        return result;
    }

    public String toString() {
        return "McBlockExtraInfo(prevBlkSignatures=" + String.valueOf(this.getPrevBlkSignatures()) + ", recoverCreateMsg=" + String.valueOf(this.getRecoverCreateMsg()) + ", mintMsg=" + String.valueOf(this.getMintMsg()) + ")";
    }

    public static class McBlockExtraInfoBuilder {
        private TonHashMapE prevBlkSignatures;
        private InMsg recoverCreateMsg;
        private InMsg mintMsg;

        McBlockExtraInfoBuilder() {
        }

        public McBlockExtraInfoBuilder prevBlkSignatures(TonHashMapE prevBlkSignatures) {
            this.prevBlkSignatures = prevBlkSignatures;
            return this;
        }

        public McBlockExtraInfoBuilder recoverCreateMsg(InMsg recoverCreateMsg) {
            this.recoverCreateMsg = recoverCreateMsg;
            return this;
        }

        public McBlockExtraInfoBuilder mintMsg(InMsg mintMsg) {
            this.mintMsg = mintMsg;
            return this;
        }

        public McBlockExtraInfo build() {
            return new McBlockExtraInfo(this.prevBlkSignatures, this.recoverCreateMsg, this.mintMsg);
        }

        public String toString() {
            return "McBlockExtraInfo.McBlockExtraInfoBuilder(prevBlkSignatures=" + String.valueOf(this.prevBlkSignatures) + ", recoverCreateMsg=" + String.valueOf(this.recoverCreateMsg) + ", mintMsg=" + String.valueOf(this.mintMsg) + ")";
        }
    }
}

