/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.JettonBridgeParams;
import org.ton.java.tlb.JettonBridgePrices;

public class JettonBridgeParamsV2
implements JettonBridgeParams {
    int magic;
    BigInteger bridgeAddress;
    BigInteger oracleAddress;
    TonHashMapE oracles;
    int stateFlags;
    JettonBridgePrices prices;
    BigInteger externalChainAddress;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(0, 8).storeUint(this.bridgeAddress, 256).storeUint(this.oracleAddress, 256).storeDict(this.oracles.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 256).endCell().getBits(), v -> CellBuilder.beginCell().storeUint((BigInteger)v, 256).endCell())).storeUint(this.stateFlags, 8).storeRef(this.prices.toCell()).storeUint(this.externalChainAddress, 256).endCell();
    }

    public static JettonBridgeParamsV2 deserialize(CellSlice cs) {
        return JettonBridgeParamsV2.builder().magic(cs.loadUint(8).intValue()).bridgeAddress(cs.loadUint(256)).oracleAddress(cs.loadUint(256)).oracles(cs.loadDictE(256, k -> k.readUint(256), v -> CellSlice.beginParse((Cell)v).loadUint(256))).stateFlags(cs.loadUint(8).intValue()).prices(JettonBridgePrices.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).externalChainAddress(cs.loadUint(256)).build();
    }

    JettonBridgeParamsV2(int magic, BigInteger bridgeAddress, BigInteger oracleAddress, TonHashMapE oracles, int stateFlags, JettonBridgePrices prices, BigInteger externalChainAddress) {
        this.magic = magic;
        this.bridgeAddress = bridgeAddress;
        this.oracleAddress = oracleAddress;
        this.oracles = oracles;
        this.stateFlags = stateFlags;
        this.prices = prices;
        this.externalChainAddress = externalChainAddress;
    }

    public static JettonBridgeParamsV2Builder builder() {
        return new JettonBridgeParamsV2Builder();
    }

    public int getMagic() {
        return this.magic;
    }

    public BigInteger getBridgeAddress() {
        return this.bridgeAddress;
    }

    public BigInteger getOracleAddress() {
        return this.oracleAddress;
    }

    public TonHashMapE getOracles() {
        return this.oracles;
    }

    public int getStateFlags() {
        return this.stateFlags;
    }

    public JettonBridgePrices getPrices() {
        return this.prices;
    }

    public BigInteger getExternalChainAddress() {
        return this.externalChainAddress;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setBridgeAddress(BigInteger bridgeAddress) {
        this.bridgeAddress = bridgeAddress;
    }

    public void setOracleAddress(BigInteger oracleAddress) {
        this.oracleAddress = oracleAddress;
    }

    public void setOracles(TonHashMapE oracles) {
        this.oracles = oracles;
    }

    public void setStateFlags(int stateFlags) {
        this.stateFlags = stateFlags;
    }

    public void setPrices(JettonBridgePrices prices) {
        this.prices = prices;
    }

    public void setExternalChainAddress(BigInteger externalChainAddress) {
        this.externalChainAddress = externalChainAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JettonBridgeParamsV2)) {
            return false;
        }
        JettonBridgeParamsV2 other = (JettonBridgeParamsV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getStateFlags() != other.getStateFlags()) {
            return false;
        }
        BigInteger this$bridgeAddress = this.getBridgeAddress();
        BigInteger other$bridgeAddress = other.getBridgeAddress();
        if (this$bridgeAddress == null ? other$bridgeAddress != null : !((Object)this$bridgeAddress).equals(other$bridgeAddress)) {
            return false;
        }
        BigInteger this$oracleAddress = this.getOracleAddress();
        BigInteger other$oracleAddress = other.getOracleAddress();
        if (this$oracleAddress == null ? other$oracleAddress != null : !((Object)this$oracleAddress).equals(other$oracleAddress)) {
            return false;
        }
        TonHashMapE this$oracles = this.getOracles();
        TonHashMapE other$oracles = other.getOracles();
        if (this$oracles == null ? other$oracles != null : !this$oracles.equals(other$oracles)) {
            return false;
        }
        JettonBridgePrices this$prices = this.getPrices();
        JettonBridgePrices other$prices = other.getPrices();
        if (this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices)) {
            return false;
        }
        BigInteger this$externalChainAddress = this.getExternalChainAddress();
        BigInteger other$externalChainAddress = other.getExternalChainAddress();
        return !(this$externalChainAddress == null ? other$externalChainAddress != null : !((Object)this$externalChainAddress).equals(other$externalChainAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JettonBridgeParamsV2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getStateFlags();
        BigInteger $bridgeAddress = this.getBridgeAddress();
        result = result * 59 + ($bridgeAddress == null ? 43 : ((Object)$bridgeAddress).hashCode());
        BigInteger $oracleAddress = this.getOracleAddress();
        result = result * 59 + ($oracleAddress == null ? 43 : ((Object)$oracleAddress).hashCode());
        TonHashMapE $oracles = this.getOracles();
        result = result * 59 + ($oracles == null ? 43 : $oracles.hashCode());
        JettonBridgePrices $prices = this.getPrices();
        result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
        BigInteger $externalChainAddress = this.getExternalChainAddress();
        result = result * 59 + ($externalChainAddress == null ? 43 : ((Object)$externalChainAddress).hashCode());
        return result;
    }

    public String toString() {
        return "JettonBridgeParamsV2(magic=" + this.getMagic() + ", bridgeAddress=" + String.valueOf(this.getBridgeAddress()) + ", oracleAddress=" + String.valueOf(this.getOracleAddress()) + ", oracles=" + String.valueOf(this.getOracles()) + ", stateFlags=" + this.getStateFlags() + ", prices=" + String.valueOf(this.getPrices()) + ", externalChainAddress=" + String.valueOf(this.getExternalChainAddress()) + ")";
    }

    public static class JettonBridgeParamsV2Builder {
        private int magic;
        private BigInteger bridgeAddress;
        private BigInteger oracleAddress;
        private TonHashMapE oracles;
        private int stateFlags;
        private JettonBridgePrices prices;
        private BigInteger externalChainAddress;

        JettonBridgeParamsV2Builder() {
        }

        public JettonBridgeParamsV2Builder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public JettonBridgeParamsV2Builder bridgeAddress(BigInteger bridgeAddress) {
            this.bridgeAddress = bridgeAddress;
            return this;
        }

        public JettonBridgeParamsV2Builder oracleAddress(BigInteger oracleAddress) {
            this.oracleAddress = oracleAddress;
            return this;
        }

        public JettonBridgeParamsV2Builder oracles(TonHashMapE oracles) {
            this.oracles = oracles;
            return this;
        }

        public JettonBridgeParamsV2Builder stateFlags(int stateFlags) {
            this.stateFlags = stateFlags;
            return this;
        }

        public JettonBridgeParamsV2Builder prices(JettonBridgePrices prices) {
            this.prices = prices;
            return this;
        }

        public JettonBridgeParamsV2Builder externalChainAddress(BigInteger externalChainAddress) {
            this.externalChainAddress = externalChainAddress;
            return this;
        }

        public JettonBridgeParamsV2 build() {
            return new JettonBridgeParamsV2(this.magic, this.bridgeAddress, this.oracleAddress, this.oracles, this.stateFlags, this.prices, this.externalChainAddress);
        }

        public String toString() {
            return "JettonBridgeParamsV2.JettonBridgeParamsV2Builder(magic=" + this.magic + ", bridgeAddress=" + String.valueOf(this.bridgeAddress) + ", oracleAddress=" + String.valueOf(this.oracleAddress) + ", oracles=" + String.valueOf(this.oracles) + ", stateFlags=" + this.stateFlags + ", prices=" + String.valueOf(this.prices) + ", externalChainAddress=" + String.valueOf(this.externalChainAddress) + ")";
        }
    }
}

