/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.JettonBridgeParams;

public class JettonBridgeParamsV1
implements JettonBridgeParams,
Serializable {
    int magic;
    BigInteger bridgeAddress;
    BigInteger oracleAddress;
    TonHashMapE oracles;
    int stateFlags;
    BigInteger burnBridgeFee;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(0, 8).storeUint(this.bridgeAddress, 256).storeUint(this.oracleAddress, 256).storeDict(this.oracles.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 256).endCell().getBits(), v -> CellBuilder.beginCell().storeUint((BigInteger)v, 256).endCell())).storeUint(this.stateFlags, 8).storeUint(this.burnBridgeFee, 256).endCell();
    }

    public static JettonBridgeParamsV1 deserialize(CellSlice cs) {
        return JettonBridgeParamsV1.builder().magic(cs.loadUint(8).intValue()).bridgeAddress(cs.loadUint(256)).oracleAddress(cs.loadUint(256)).oracles(cs.loadDictE(256, k -> k.readUint(256), v -> CellSlice.beginParse((Cell)v).loadUint(256))).stateFlags(cs.loadUint(8).intValue()).burnBridgeFee(cs.loadCoins()).build();
    }

    JettonBridgeParamsV1(int magic, BigInteger bridgeAddress, BigInteger oracleAddress, TonHashMapE oracles, int stateFlags, BigInteger burnBridgeFee) {
        this.magic = magic;
        this.bridgeAddress = bridgeAddress;
        this.oracleAddress = oracleAddress;
        this.oracles = oracles;
        this.stateFlags = stateFlags;
        this.burnBridgeFee = burnBridgeFee;
    }

    public static JettonBridgeParamsV1Builder builder() {
        return new JettonBridgeParamsV1Builder();
    }

    public int getMagic() {
        return this.magic;
    }

    public BigInteger getBridgeAddress() {
        return this.bridgeAddress;
    }

    public BigInteger getOracleAddress() {
        return this.oracleAddress;
    }

    public TonHashMapE getOracles() {
        return this.oracles;
    }

    public int getStateFlags() {
        return this.stateFlags;
    }

    public BigInteger getBurnBridgeFee() {
        return this.burnBridgeFee;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setBridgeAddress(BigInteger bridgeAddress) {
        this.bridgeAddress = bridgeAddress;
    }

    public void setOracleAddress(BigInteger oracleAddress) {
        this.oracleAddress = oracleAddress;
    }

    public void setOracles(TonHashMapE oracles) {
        this.oracles = oracles;
    }

    public void setStateFlags(int stateFlags) {
        this.stateFlags = stateFlags;
    }

    public void setBurnBridgeFee(BigInteger burnBridgeFee) {
        this.burnBridgeFee = burnBridgeFee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JettonBridgeParamsV1)) {
            return false;
        }
        JettonBridgeParamsV1 other = (JettonBridgeParamsV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getStateFlags() != other.getStateFlags()) {
            return false;
        }
        BigInteger this$bridgeAddress = this.getBridgeAddress();
        BigInteger other$bridgeAddress = other.getBridgeAddress();
        if (this$bridgeAddress == null ? other$bridgeAddress != null : !((Object)this$bridgeAddress).equals(other$bridgeAddress)) {
            return false;
        }
        BigInteger this$oracleAddress = this.getOracleAddress();
        BigInteger other$oracleAddress = other.getOracleAddress();
        if (this$oracleAddress == null ? other$oracleAddress != null : !((Object)this$oracleAddress).equals(other$oracleAddress)) {
            return false;
        }
        TonHashMapE this$oracles = this.getOracles();
        TonHashMapE other$oracles = other.getOracles();
        if (this$oracles == null ? other$oracles != null : !this$oracles.equals(other$oracles)) {
            return false;
        }
        BigInteger this$burnBridgeFee = this.getBurnBridgeFee();
        BigInteger other$burnBridgeFee = other.getBurnBridgeFee();
        return !(this$burnBridgeFee == null ? other$burnBridgeFee != null : !((Object)this$burnBridgeFee).equals(other$burnBridgeFee));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JettonBridgeParamsV1;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getStateFlags();
        BigInteger $bridgeAddress = this.getBridgeAddress();
        result = result * 59 + ($bridgeAddress == null ? 43 : ((Object)$bridgeAddress).hashCode());
        BigInteger $oracleAddress = this.getOracleAddress();
        result = result * 59 + ($oracleAddress == null ? 43 : ((Object)$oracleAddress).hashCode());
        TonHashMapE $oracles = this.getOracles();
        result = result * 59 + ($oracles == null ? 43 : $oracles.hashCode());
        BigInteger $burnBridgeFee = this.getBurnBridgeFee();
        result = result * 59 + ($burnBridgeFee == null ? 43 : ((Object)$burnBridgeFee).hashCode());
        return result;
    }

    public String toString() {
        return "JettonBridgeParamsV1(magic=" + this.getMagic() + ", bridgeAddress=" + String.valueOf(this.getBridgeAddress()) + ", oracleAddress=" + String.valueOf(this.getOracleAddress()) + ", oracles=" + String.valueOf(this.getOracles()) + ", stateFlags=" + this.getStateFlags() + ", burnBridgeFee=" + String.valueOf(this.getBurnBridgeFee()) + ")";
    }

    public static class JettonBridgeParamsV1Builder {
        private int magic;
        private BigInteger bridgeAddress;
        private BigInteger oracleAddress;
        private TonHashMapE oracles;
        private int stateFlags;
        private BigInteger burnBridgeFee;

        JettonBridgeParamsV1Builder() {
        }

        public JettonBridgeParamsV1Builder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public JettonBridgeParamsV1Builder bridgeAddress(BigInteger bridgeAddress) {
            this.bridgeAddress = bridgeAddress;
            return this;
        }

        public JettonBridgeParamsV1Builder oracleAddress(BigInteger oracleAddress) {
            this.oracleAddress = oracleAddress;
            return this;
        }

        public JettonBridgeParamsV1Builder oracles(TonHashMapE oracles) {
            this.oracles = oracles;
            return this;
        }

        public JettonBridgeParamsV1Builder stateFlags(int stateFlags) {
            this.stateFlags = stateFlags;
            return this;
        }

        public JettonBridgeParamsV1Builder burnBridgeFee(BigInteger burnBridgeFee) {
            this.burnBridgeFee = burnBridgeFee;
            return this;
        }

        public JettonBridgeParamsV1 build() {
            return new JettonBridgeParamsV1(this.magic, this.bridgeAddress, this.oracleAddress, this.oracles, this.stateFlags, this.burnBridgeFee);
        }

        public String toString() {
            return "JettonBridgeParamsV1.JettonBridgeParamsV1Builder(magic=" + this.magic + ", bridgeAddress=" + String.valueOf(this.bridgeAddress) + ", oracleAddress=" + String.valueOf(this.oracleAddress) + ", oracles=" + String.valueOf(this.oracles) + ", stateFlags=" + this.stateFlags + ", burnBridgeFee=" + String.valueOf(this.burnBridgeFee) + ")";
        }
    }
}

