/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.MsgAddressInt;

public class InternalMessageInfo
implements CommonMsgInfo,
Serializable {
    int magic;
    Boolean iHRDisabled;
    Boolean bounce;
    Boolean bounced;
    MsgAddressInt srcAddr;
    MsgAddressInt dstAddr;
    CurrencyCollection value;
    BigInteger iHRFee;
    BigInteger fwdFee;
    BigInteger createdLt;
    long createdAt;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    @Override
    public Cell toCell() {
        CellBuilder result = CellBuilder.beginCell().storeUint(0, 1).storeBit(Boolean.valueOf(Objects.isNull(this.iHRDisabled) || this.iHRDisabled != false)).storeBit(Boolean.valueOf(Objects.isNull(this.bounce) || this.bounce != false)).storeBit(Boolean.valueOf(!Objects.isNull(this.bounced) && this.bounced != false)).storeCell(this.srcAddr.toCell()).storeCell(this.dstAddr.toCell()).storeCell(Objects.isNull(this.value) ? CurrencyCollection.builder().coins(BigInteger.ZERO).build().toCell() : this.value.toCell()).storeCoins(Objects.isNull(this.iHRFee) ? BigInteger.ZERO : this.iHRFee).storeCoins(Objects.isNull(this.fwdFee) ? BigInteger.ZERO : this.fwdFee).storeUint(Objects.isNull(this.createdLt) ? BigInteger.ZERO : this.createdLt, 64).storeUint(this.createdAt, 32);
        return result.endCell();
    }

    public static InternalMessageInfo deserialize(CellSlice cs) {
        int magic = cs.loadUint(1).intValue();
        assert (magic == 0) : "InternalMessage: magic not equal to 0b0, found " + magic;
        return InternalMessageInfo.builder().magic(magic).iHRDisabled(cs.loadBit()).bounce(cs.loadBit()).bounced(cs.loadBit()).srcAddr(MsgAddressInt.deserialize(cs)).dstAddr(MsgAddressInt.deserialize(cs)).value(CurrencyCollection.deserialize(cs)).iHRFee(cs.loadCoins()).fwdFee(cs.loadCoins()).createdLt(cs.loadUint(64)).createdAt(cs.loadUint(32).longValue()).build();
    }

    @Override
    public String getType() {
        return "int_msg_info";
    }

    @Override
    public String getSourceAddress() {
        return this.srcAddr.toAddress().toRaw();
    }

    @Override
    public String getDestinationAddress() {
        return this.dstAddr.toAddress().toRaw();
    }

    @Override
    public BigInteger getValueCoins() {
        return this.value.getCoins();
    }

    @Override
    public HashMap getExtraCurrencies() {
        return this.value.getExtraCurrencies().elements;
    }

    public BigInteger getTotalFees() {
        return this.iHRFee.add(this.fwdFee);
    }

    InternalMessageInfo(int magic, Boolean iHRDisabled, Boolean bounce, Boolean bounced, MsgAddressInt srcAddr, MsgAddressInt dstAddr, CurrencyCollection value, BigInteger iHRFee, BigInteger fwdFee, BigInteger createdLt, long createdAt) {
        this.magic = magic;
        this.iHRDisabled = iHRDisabled;
        this.bounce = bounce;
        this.bounced = bounced;
        this.srcAddr = srcAddr;
        this.dstAddr = dstAddr;
        this.value = value;
        this.iHRFee = iHRFee;
        this.fwdFee = fwdFee;
        this.createdLt = createdLt;
        this.createdAt = createdAt;
    }

    public static InternalMessageInfoBuilder builder() {
        return new InternalMessageInfoBuilder();
    }

    public Boolean getIHRDisabled() {
        return this.iHRDisabled;
    }

    public Boolean getBounce() {
        return this.bounce;
    }

    public Boolean getBounced() {
        return this.bounced;
    }

    public MsgAddressInt getSrcAddr() {
        return this.srcAddr;
    }

    public MsgAddressInt getDstAddr() {
        return this.dstAddr;
    }

    public CurrencyCollection getValue() {
        return this.value;
    }

    public BigInteger getIHRFee() {
        return this.iHRFee;
    }

    public BigInteger getFwdFee() {
        return this.fwdFee;
    }

    public BigInteger getCreatedLt() {
        return this.createdLt;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setIHRDisabled(Boolean iHRDisabled) {
        this.iHRDisabled = iHRDisabled;
    }

    public void setBounce(Boolean bounce) {
        this.bounce = bounce;
    }

    public void setBounced(Boolean bounced) {
        this.bounced = bounced;
    }

    public void setSrcAddr(MsgAddressInt srcAddr) {
        this.srcAddr = srcAddr;
    }

    public void setDstAddr(MsgAddressInt dstAddr) {
        this.dstAddr = dstAddr;
    }

    public void setValue(CurrencyCollection value) {
        this.value = value;
    }

    public void setIHRFee(BigInteger iHRFee) {
        this.iHRFee = iHRFee;
    }

    public void setFwdFee(BigInteger fwdFee) {
        this.fwdFee = fwdFee;
    }

    public void setCreatedLt(BigInteger createdLt) {
        this.createdLt = createdLt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalMessageInfo)) {
            return false;
        }
        InternalMessageInfo other = (InternalMessageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        Boolean this$iHRDisabled = this.getIHRDisabled();
        Boolean other$iHRDisabled = other.getIHRDisabled();
        if (this$iHRDisabled == null ? other$iHRDisabled != null : !((Object)this$iHRDisabled).equals(other$iHRDisabled)) {
            return false;
        }
        Boolean this$bounce = this.getBounce();
        Boolean other$bounce = other.getBounce();
        if (this$bounce == null ? other$bounce != null : !((Object)this$bounce).equals(other$bounce)) {
            return false;
        }
        Boolean this$bounced = this.getBounced();
        Boolean other$bounced = other.getBounced();
        if (this$bounced == null ? other$bounced != null : !((Object)this$bounced).equals(other$bounced)) {
            return false;
        }
        MsgAddressInt this$srcAddr = this.getSrcAddr();
        MsgAddressInt other$srcAddr = other.getSrcAddr();
        if (this$srcAddr == null ? other$srcAddr != null : !this$srcAddr.equals(other$srcAddr)) {
            return false;
        }
        MsgAddressInt this$dstAddr = this.getDstAddr();
        MsgAddressInt other$dstAddr = other.getDstAddr();
        if (this$dstAddr == null ? other$dstAddr != null : !this$dstAddr.equals(other$dstAddr)) {
            return false;
        }
        CurrencyCollection this$value = this.getValue();
        CurrencyCollection other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        BigInteger this$iHRFee = this.getIHRFee();
        BigInteger other$iHRFee = other.getIHRFee();
        if (this$iHRFee == null ? other$iHRFee != null : !((Object)this$iHRFee).equals(other$iHRFee)) {
            return false;
        }
        BigInteger this$fwdFee = this.getFwdFee();
        BigInteger other$fwdFee = other.getFwdFee();
        if (this$fwdFee == null ? other$fwdFee != null : !((Object)this$fwdFee).equals(other$fwdFee)) {
            return false;
        }
        BigInteger this$createdLt = this.getCreatedLt();
        BigInteger other$createdLt = other.getCreatedLt();
        return !(this$createdLt == null ? other$createdLt != null : !((Object)this$createdLt).equals(other$createdLt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InternalMessageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        Boolean $iHRDisabled = this.getIHRDisabled();
        result = result * 59 + ($iHRDisabled == null ? 43 : ((Object)$iHRDisabled).hashCode());
        Boolean $bounce = this.getBounce();
        result = result * 59 + ($bounce == null ? 43 : ((Object)$bounce).hashCode());
        Boolean $bounced = this.getBounced();
        result = result * 59 + ($bounced == null ? 43 : ((Object)$bounced).hashCode());
        MsgAddressInt $srcAddr = this.getSrcAddr();
        result = result * 59 + ($srcAddr == null ? 43 : $srcAddr.hashCode());
        MsgAddressInt $dstAddr = this.getDstAddr();
        result = result * 59 + ($dstAddr == null ? 43 : $dstAddr.hashCode());
        CurrencyCollection $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        BigInteger $iHRFee = this.getIHRFee();
        result = result * 59 + ($iHRFee == null ? 43 : ((Object)$iHRFee).hashCode());
        BigInteger $fwdFee = this.getFwdFee();
        result = result * 59 + ($fwdFee == null ? 43 : ((Object)$fwdFee).hashCode());
        BigInteger $createdLt = this.getCreatedLt();
        result = result * 59 + ($createdLt == null ? 43 : ((Object)$createdLt).hashCode());
        return result;
    }

    public String toString() {
        return "InternalMessageInfo(magic=" + this.getMagic() + ", iHRDisabled=" + this.getIHRDisabled() + ", bounce=" + this.getBounce() + ", bounced=" + this.getBounced() + ", srcAddr=" + String.valueOf(this.getSrcAddr()) + ", dstAddr=" + String.valueOf(this.getDstAddr()) + ", value=" + String.valueOf(this.getValue()) + ", iHRFee=" + String.valueOf(this.getIHRFee()) + ", fwdFee=" + String.valueOf(this.getFwdFee()) + ", createdLt=" + String.valueOf(this.getCreatedLt()) + ", createdAt=" + this.getCreatedAt() + ")";
    }

    public static class InternalMessageInfoBuilder {
        private int magic;
        private Boolean iHRDisabled;
        private Boolean bounce;
        private Boolean bounced;
        private MsgAddressInt srcAddr;
        private MsgAddressInt dstAddr;
        private CurrencyCollection value;
        private BigInteger iHRFee;
        private BigInteger fwdFee;
        private BigInteger createdLt;
        private long createdAt;

        InternalMessageInfoBuilder() {
        }

        public InternalMessageInfoBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public InternalMessageInfoBuilder iHRDisabled(Boolean iHRDisabled) {
            this.iHRDisabled = iHRDisabled;
            return this;
        }

        public InternalMessageInfoBuilder bounce(Boolean bounce) {
            this.bounce = bounce;
            return this;
        }

        public InternalMessageInfoBuilder bounced(Boolean bounced) {
            this.bounced = bounced;
            return this;
        }

        public InternalMessageInfoBuilder srcAddr(MsgAddressInt srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public InternalMessageInfoBuilder dstAddr(MsgAddressInt dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public InternalMessageInfoBuilder value(CurrencyCollection value) {
            this.value = value;
            return this;
        }

        public InternalMessageInfoBuilder iHRFee(BigInteger iHRFee) {
            this.iHRFee = iHRFee;
            return this;
        }

        public InternalMessageInfoBuilder fwdFee(BigInteger fwdFee) {
            this.fwdFee = fwdFee;
            return this;
        }

        public InternalMessageInfoBuilder createdLt(BigInteger createdLt) {
            this.createdLt = createdLt;
            return this;
        }

        public InternalMessageInfoBuilder createdAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public InternalMessageInfo build() {
            return new InternalMessageInfo(this.magic, this.iHRDisabled, this.bounce, this.bounced, this.srcAddr, this.dstAddr, this.value, this.iHRFee, this.fwdFee, this.createdLt, this.createdAt);
        }

        public String toString() {
            return "InternalMessageInfo.InternalMessageInfoBuilder(magic=" + this.magic + ", iHRDisabled=" + this.iHRDisabled + ", bounce=" + this.bounce + ", bounced=" + this.bounced + ", srcAddr=" + String.valueOf(this.srcAddr) + ", dstAddr=" + String.valueOf(this.dstAddr) + ", value=" + String.valueOf(this.value) + ", iHRFee=" + String.valueOf(this.iHRFee) + ", fwdFee=" + String.valueOf(this.fwdFee) + ", createdLt=" + String.valueOf(this.createdLt) + ", createdAt=" + this.createdAt + ")";
        }
    }
}

