/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import org.ton.java.cell.Cell;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.InMsgDiscardFin;
import org.ton.java.tlb.InMsgDiscardTr;
import org.ton.java.tlb.InMsgImportExt;
import org.ton.java.tlb.InMsgImportFin;
import org.ton.java.tlb.InMsgImportIhr;
import org.ton.java.tlb.InMsgImportImm;
import org.ton.java.tlb.InMsgImportTr;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MsgEnvelope;
import org.ton.java.tlb.Transaction;

public interface InMsg {
    public Cell toCell();

    public static InMsg deserialize(CellSlice cs) {
        int inMsgFlag = cs.loadUint(3).intValue();
        switch (inMsgFlag) {
            case 0: {
                return InMsgImportExt.builder().msg(Message.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transaction(Transaction.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
            }
            case 2: {
                return InMsgImportIhr.builder().msg(Message.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transaction(Transaction.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).ihrFee(cs.loadCoins()).proofCreated(cs.loadRef()).build();
            }
            case 3: {
                return InMsgImportImm.builder().inMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transaction(Transaction.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).fwdFee(cs.loadCoins()).build();
            }
            case 4: {
                return InMsgImportFin.builder().inMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transaction(Transaction.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).fwdFee(cs.loadCoins()).build();
            }
            case 5: {
                return InMsgImportTr.builder().inMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).outMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transitFee(cs.loadCoins()).build();
            }
            case 6: {
                return InMsgDiscardFin.builder().inMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transactionId(cs.loadUint(64)).fwdFee(cs.loadCoins()).build();
            }
            case 7: {
                return InMsgDiscardTr.builder().inMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).transactionId(cs.loadUint(64)).fwdFee(cs.loadCoins()).proofDelivered(cs.loadRef()).build();
            }
        }
        throw new Error("unknown in_msg flag, found 0x" + Long.toBinaryString(inMsgFlag));
    }
}

