/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CurrencyCollection;

public class ImportFees
implements Serializable {
    BigInteger feesCollected;
    CurrencyCollection valueImported;

    public Cell toCell() {
        return CellBuilder.beginCell().storeCoins(this.feesCollected).storeCell(this.valueImported.toCell()).endCell();
    }

    public static ImportFees deserialize(CellSlice cs) {
        return ImportFees.builder().feesCollected(cs.loadCoins()).valueImported(CurrencyCollection.deserialize(cs)).build();
    }

    ImportFees(BigInteger feesCollected, CurrencyCollection valueImported) {
        this.feesCollected = feesCollected;
        this.valueImported = valueImported;
    }

    public static ImportFeesBuilder builder() {
        return new ImportFeesBuilder();
    }

    public BigInteger getFeesCollected() {
        return this.feesCollected;
    }

    public CurrencyCollection getValueImported() {
        return this.valueImported;
    }

    public void setFeesCollected(BigInteger feesCollected) {
        this.feesCollected = feesCollected;
    }

    public void setValueImported(CurrencyCollection valueImported) {
        this.valueImported = valueImported;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportFees)) {
            return false;
        }
        ImportFees other = (ImportFees)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$feesCollected = this.getFeesCollected();
        BigInteger other$feesCollected = other.getFeesCollected();
        if (this$feesCollected == null ? other$feesCollected != null : !((Object)this$feesCollected).equals(other$feesCollected)) {
            return false;
        }
        CurrencyCollection this$valueImported = this.getValueImported();
        CurrencyCollection other$valueImported = other.getValueImported();
        return !(this$valueImported == null ? other$valueImported != null : !((Object)this$valueImported).equals(other$valueImported));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImportFees;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $feesCollected = this.getFeesCollected();
        result = result * 59 + ($feesCollected == null ? 43 : ((Object)$feesCollected).hashCode());
        CurrencyCollection $valueImported = this.getValueImported();
        result = result * 59 + ($valueImported == null ? 43 : ((Object)$valueImported).hashCode());
        return result;
    }

    public String toString() {
        return "ImportFees(feesCollected=" + String.valueOf(this.getFeesCollected()) + ", valueImported=" + String.valueOf(this.getValueImported()) + ")";
    }

    public static class ImportFeesBuilder {
        private BigInteger feesCollected;
        private CurrencyCollection valueImported;

        ImportFeesBuilder() {
        }

        public ImportFeesBuilder feesCollected(BigInteger feesCollected) {
            this.feesCollected = feesCollected;
            return this;
        }

        public ImportFeesBuilder valueImported(CurrencyCollection valueImported) {
            this.valueImported = valueImported;
            return this;
        }

        public ImportFees build() {
            return new ImportFees(this.feesCollected, this.valueImported);
        }

        public String toString() {
            return "ImportFees.ImportFeesBuilder(feesCollected=" + String.valueOf(this.feesCollected) + ", valueImported=" + String.valueOf(this.valueImported) + ")";
        }
    }
}

