/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class HashUpdate
implements Serializable {
    int magic;
    BigInteger oldHash;
    BigInteger newHash;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    private String getOldHash() {
        return this.oldHash.toString(16);
    }

    private String getNewHash() {
        return this.newHash.toString(16);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(114, 32).storeUint(this.oldHash, 256).storeUint(this.newHash, 256).endCell();
    }

    public static HashUpdate deserialize(CellSlice cs) {
        long magic = cs.loadUint(8).intValue();
        assert (magic == 114L) : "HashUpdate: magic not equal to 0x72, found 0x" + Long.toHexString(magic);
        return HashUpdate.builder().magic(114).oldHash(cs.loadUint(256)).newHash(cs.loadUint(256)).build();
    }

    HashUpdate(int magic, BigInteger oldHash, BigInteger newHash) {
        this.magic = magic;
        this.oldHash = oldHash;
        this.newHash = newHash;
    }

    public static HashUpdateBuilder builder() {
        return new HashUpdateBuilder();
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setOldHash(BigInteger oldHash) {
        this.oldHash = oldHash;
    }

    public void setNewHash(BigInteger newHash) {
        this.newHash = newHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashUpdate)) {
            return false;
        }
        HashUpdate other = (HashUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        String this$oldHash = this.getOldHash();
        String other$oldHash = other.getOldHash();
        if (this$oldHash == null ? other$oldHash != null : !this$oldHash.equals(other$oldHash)) {
            return false;
        }
        String this$newHash = this.getNewHash();
        String other$newHash = other.getNewHash();
        return !(this$newHash == null ? other$newHash != null : !this$newHash.equals(other$newHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HashUpdate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        String $oldHash = this.getOldHash();
        result = result * 59 + ($oldHash == null ? 43 : $oldHash.hashCode());
        String $newHash = this.getNewHash();
        result = result * 59 + ($newHash == null ? 43 : $newHash.hashCode());
        return result;
    }

    public String toString() {
        return "HashUpdate(magic=" + this.getMagic() + ", oldHash=" + this.getOldHash() + ", newHash=" + this.getNewHash() + ")";
    }

    public static class HashUpdateBuilder {
        private int magic;
        private BigInteger oldHash;
        private BigInteger newHash;

        HashUpdateBuilder() {
        }

        public HashUpdateBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public HashUpdateBuilder oldHash(BigInteger oldHash) {
            this.oldHash = oldHash;
            return this;
        }

        public HashUpdateBuilder newHash(BigInteger newHash) {
            this.newHash = newHash;
            return this;
        }

        public HashUpdate build() {
            return new HashUpdate(this.magic, this.oldHash, this.newHash);
        }

        public String toString() {
            return "HashUpdate.HashUpdateBuilder(magic=" + this.magic + ", oldHash=" + String.valueOf(this.oldHash) + ", newHash=" + String.valueOf(this.newHash) + ")";
        }
    }
}

