/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class GlobalVersion
implements Serializable {
    long magic;
    long version;
    BigInteger capabilities;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(196, 32).storeUint(this.version, 32).storeUint(this.capabilities, 64).endCell();
    }

    public static GlobalVersion deserialize(CellSlice cs) {
        long magic = cs.loadUint(8).longValue();
        assert (magic == 196L) : "GlobalVersion: magic not equal to 0xc4, found 0x" + Long.toHexString(magic);
        return GlobalVersion.builder().magic(196L).version(cs.loadUint(32).longValue()).capabilities(cs.loadUint(64)).build();
    }

    GlobalVersion(long magic, long version, BigInteger capabilities) {
        this.magic = magic;
        this.version = version;
        this.capabilities = capabilities;
    }

    public static GlobalVersionBuilder builder() {
        return new GlobalVersionBuilder();
    }

    public long getVersion() {
        return this.version;
    }

    public BigInteger getCapabilities() {
        return this.capabilities;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setCapabilities(BigInteger capabilities) {
        this.capabilities = capabilities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalVersion)) {
            return false;
        }
        GlobalVersion other = (GlobalVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        BigInteger this$capabilities = this.getCapabilities();
        BigInteger other$capabilities = other.getCapabilities();
        return !(this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        BigInteger $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        return result;
    }

    public String toString() {
        return "GlobalVersion(magic=" + this.getMagic() + ", version=" + this.getVersion() + ", capabilities=" + String.valueOf(this.getCapabilities()) + ")";
    }

    public static class GlobalVersionBuilder {
        private long magic;
        private long version;
        private BigInteger capabilities;

        GlobalVersionBuilder() {
        }

        public GlobalVersionBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public GlobalVersionBuilder version(long version) {
            this.version = version;
            return this;
        }

        public GlobalVersionBuilder capabilities(BigInteger capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public GlobalVersion build() {
            return new GlobalVersion(this.magic, this.version, this.capabilities);
        }

        public String toString() {
            return "GlobalVersion.GlobalVersionBuilder(magic=" + this.magic + ", version=" + this.version + ", capabilities=" + String.valueOf(this.capabilities) + ")";
        }
    }
}

