/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class FutureSplitMerge
implements Serializable {
    int flag;
    long splitUTime;
    long mergeUTime;
    long interval;

    public Cell toCell() {
        if (this.flag == 0) {
            return CellBuilder.beginCell().storeUint(0, 1).endCell();
        }
        if (this.flag == 2) {
            return CellBuilder.beginCell().storeUint(2, 2).storeUint(this.splitUTime, 32).storeUint(this.interval, 32).endCell();
        }
        if (this.flag == 3) {
            return CellBuilder.beginCell().storeUint(3, 2).storeUint(this.mergeUTime, 32).storeUint(this.interval, 32).endCell();
        }
        throw new Error("Wrong flag at FutureSplitMerge, must be 0b0, 0b10 or 0b11, got " + this.flag);
    }

    public static FutureSplitMerge deserialize(CellSlice cs) {
        int flag = cs.loadUint(1).intValue();
        if (flag == 0) {
            return FutureSplitMerge.builder().build();
        }
        flag = cs.loadUint(1).intValue();
        if (flag == 0) {
            return FutureSplitMerge.builder().splitUTime(cs.loadUint(32).longValue()).interval(cs.loadUint(32).longValue()).build();
        }
        return FutureSplitMerge.builder().mergeUTime(cs.loadUint(32).longValue()).interval(cs.loadUint(32).longValue()).build();
    }

    FutureSplitMerge(int flag, long splitUTime, long mergeUTime, long interval) {
        this.flag = flag;
        this.splitUTime = splitUTime;
        this.mergeUTime = mergeUTime;
        this.interval = interval;
    }

    public static FutureSplitMergeBuilder builder() {
        return new FutureSplitMergeBuilder();
    }

    public int getFlag() {
        return this.flag;
    }

    public long getSplitUTime() {
        return this.splitUTime;
    }

    public long getMergeUTime() {
        return this.mergeUTime;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public void setSplitUTime(long splitUTime) {
        this.splitUTime = splitUTime;
    }

    public void setMergeUTime(long mergeUTime) {
        this.mergeUTime = mergeUTime;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FutureSplitMerge)) {
            return false;
        }
        FutureSplitMerge other = (FutureSplitMerge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFlag() != other.getFlag()) {
            return false;
        }
        if (this.getSplitUTime() != other.getSplitUTime()) {
            return false;
        }
        if (this.getMergeUTime() != other.getMergeUTime()) {
            return false;
        }
        return this.getInterval() == other.getInterval();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FutureSplitMerge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFlag();
        long $splitUTime = this.getSplitUTime();
        result = result * 59 + (int)($splitUTime >>> 32 ^ $splitUTime);
        long $mergeUTime = this.getMergeUTime();
        result = result * 59 + (int)($mergeUTime >>> 32 ^ $mergeUTime);
        long $interval = this.getInterval();
        result = result * 59 + (int)($interval >>> 32 ^ $interval);
        return result;
    }

    public String toString() {
        return "FutureSplitMerge(flag=" + this.getFlag() + ", splitUTime=" + this.getSplitUTime() + ", mergeUTime=" + this.getMergeUTime() + ", interval=" + this.getInterval() + ")";
    }

    public static class FutureSplitMergeBuilder {
        private int flag;
        private long splitUTime;
        private long mergeUTime;
        private long interval;

        FutureSplitMergeBuilder() {
        }

        public FutureSplitMergeBuilder flag(int flag) {
            this.flag = flag;
            return this;
        }

        public FutureSplitMergeBuilder splitUTime(long splitUTime) {
            this.splitUTime = splitUTime;
            return this;
        }

        public FutureSplitMergeBuilder mergeUTime(long mergeUTime) {
            this.mergeUTime = mergeUTime;
            return this;
        }

        public FutureSplitMergeBuilder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public FutureSplitMerge build() {
            return new FutureSplitMerge(this.flag, this.splitUTime, this.mergeUTime, this.interval);
        }

        public String toString() {
            return "FutureSplitMerge.FutureSplitMergeBuilder(flag=" + this.flag + ", splitUTime=" + this.splitUTime + ", mergeUTime=" + this.mergeUTime + ", interval=" + this.interval + ")";
        }
    }
}

