/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.MsgAddressExt;
import org.ton.java.tlb.MsgAddressExtNone;
import org.ton.java.tlb.MsgAddressInt;

public class ExternalMessageOutInfo
implements CommonMsgInfo,
Serializable {
    long magic;
    MsgAddressInt srcAddr;
    MsgAddressExt dstAddr;
    BigInteger createdLt;
    long createdAt;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    @Override
    public Cell toCell() {
        CellBuilder result = CellBuilder.beginCell().storeUint(3, 2).storeCell(Objects.isNull(this.srcAddr) ? MsgAddressExtNone.builder().build().toCell() : this.srcAddr.toCell()).storeCell(this.dstAddr.toCell()).storeUint(Objects.isNull(this.createdLt) ? BigInteger.ZERO : this.createdLt, 64).storeUint(this.createdAt, 32);
        return result.endCell();
    }

    public static ExternalMessageOutInfo deserialize(CellSlice cs) {
        long magic = cs.loadUint(2).intValue();
        assert (magic == 3L) : "ExternalMessageOut: magic not equal to 0b11, found 0b" + Long.toBinaryString(magic);
        return ExternalMessageOutInfo.builder().magic(magic).srcAddr(MsgAddressInt.deserialize(cs)).dstAddr(MsgAddressExt.deserialize(cs)).createdLt(cs.loadUint(64)).createdAt(cs.loadUint(32).longValue()).build();
    }

    @Override
    public String getType() {
        return "ext_out_msg_info";
    }

    @Override
    public String getSourceAddress() {
        return this.srcAddr.toAddress().toRaw();
    }

    @Override
    public String getDestinationAddress() {
        return this.dstAddr.toString();
    }

    @Override
    public BigInteger getValueCoins() {
        return BigInteger.ZERO;
    }

    @Override
    public HashMap getExtraCurrencies() {
        return new HashMap();
    }

    ExternalMessageOutInfo(long magic, MsgAddressInt srcAddr, MsgAddressExt dstAddr, BigInteger createdLt, long createdAt) {
        this.magic = magic;
        this.srcAddr = srcAddr;
        this.dstAddr = dstAddr;
        this.createdLt = createdLt;
        this.createdAt = createdAt;
    }

    public static ExternalMessageOutInfoBuilder builder() {
        return new ExternalMessageOutInfoBuilder();
    }

    public MsgAddressInt getSrcAddr() {
        return this.srcAddr;
    }

    public MsgAddressExt getDstAddr() {
        return this.dstAddr;
    }

    public BigInteger getCreatedLt() {
        return this.createdLt;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setSrcAddr(MsgAddressInt srcAddr) {
        this.srcAddr = srcAddr;
    }

    public void setDstAddr(MsgAddressExt dstAddr) {
        this.dstAddr = dstAddr;
    }

    public void setCreatedLt(BigInteger createdLt) {
        this.createdLt = createdLt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalMessageOutInfo)) {
            return false;
        }
        ExternalMessageOutInfo other = (ExternalMessageOutInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        MsgAddressInt this$srcAddr = this.getSrcAddr();
        MsgAddressInt other$srcAddr = other.getSrcAddr();
        if (this$srcAddr == null ? other$srcAddr != null : !this$srcAddr.equals(other$srcAddr)) {
            return false;
        }
        MsgAddressExt this$dstAddr = this.getDstAddr();
        MsgAddressExt other$dstAddr = other.getDstAddr();
        if (this$dstAddr == null ? other$dstAddr != null : !this$dstAddr.equals(other$dstAddr)) {
            return false;
        }
        BigInteger this$createdLt = this.getCreatedLt();
        BigInteger other$createdLt = other.getCreatedLt();
        return !(this$createdLt == null ? other$createdLt != null : !((Object)this$createdLt).equals(other$createdLt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalMessageOutInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        MsgAddressInt $srcAddr = this.getSrcAddr();
        result = result * 59 + ($srcAddr == null ? 43 : $srcAddr.hashCode());
        MsgAddressExt $dstAddr = this.getDstAddr();
        result = result * 59 + ($dstAddr == null ? 43 : $dstAddr.hashCode());
        BigInteger $createdLt = this.getCreatedLt();
        result = result * 59 + ($createdLt == null ? 43 : ((Object)$createdLt).hashCode());
        return result;
    }

    public String toString() {
        return "ExternalMessageOutInfo(magic=" + this.getMagic() + ", srcAddr=" + String.valueOf(this.getSrcAddr()) + ", dstAddr=" + String.valueOf(this.getDstAddr()) + ", createdLt=" + String.valueOf(this.getCreatedLt()) + ", createdAt=" + this.getCreatedAt() + ")";
    }

    public static class ExternalMessageOutInfoBuilder {
        private long magic;
        private MsgAddressInt srcAddr;
        private MsgAddressExt dstAddr;
        private BigInteger createdLt;
        private long createdAt;

        ExternalMessageOutInfoBuilder() {
        }

        public ExternalMessageOutInfoBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ExternalMessageOutInfoBuilder srcAddr(MsgAddressInt srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public ExternalMessageOutInfoBuilder dstAddr(MsgAddressExt dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public ExternalMessageOutInfoBuilder createdLt(BigInteger createdLt) {
            this.createdLt = createdLt;
            return this;
        }

        public ExternalMessageOutInfoBuilder createdAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ExternalMessageOutInfo build() {
            return new ExternalMessageOutInfo(this.magic, this.srcAddr, this.dstAddr, this.createdLt, this.createdAt);
        }

        public String toString() {
            return "ExternalMessageOutInfo.ExternalMessageOutInfoBuilder(magic=" + this.magic + ", srcAddr=" + String.valueOf(this.srcAddr) + ", dstAddr=" + String.valueOf(this.dstAddr) + ", createdLt=" + String.valueOf(this.createdLt) + ", createdAt=" + this.createdAt + ")";
        }
    }
}

