/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.MsgAddressExt;
import org.ton.java.tlb.MsgAddressExtNone;
import org.ton.java.tlb.MsgAddressInt;

public class ExternalMessageInInfo
implements CommonMsgInfo,
Serializable {
    long magic;
    MsgAddressExt srcAddr;
    MsgAddressInt dstAddr;
    BigInteger importFee;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    @Override
    public Cell toCell() {
        CellBuilder result = CellBuilder.beginCell().storeUint(2, 2).storeCell(Objects.isNull(this.srcAddr) ? MsgAddressExtNone.builder().build().toCell() : this.srcAddr.toCell()).storeCell(this.dstAddr.toCell()).storeCoins(Objects.isNull(this.importFee) ? BigInteger.ZERO : this.importFee);
        return result.endCell();
    }

    public static ExternalMessageInInfo deserialize(CellSlice cs) {
        long magic = cs.loadUint(2).intValue();
        assert (magic == 2L) : "ExternalMessage: magic not equal to 0b10, found 0b" + Long.toBinaryString(magic);
        return ExternalMessageInInfo.builder().magic(magic).srcAddr(MsgAddressExt.deserialize(cs)).dstAddr(MsgAddressInt.deserialize(cs)).importFee(cs.loadCoins()).build();
    }

    @Override
    public String getType() {
        return "ext_in_msg_info";
    }

    @Override
    public String getSourceAddress() {
        return this.srcAddr.toString();
    }

    @Override
    public String getDestinationAddress() {
        return this.dstAddr.toAddress().toRaw();
    }

    @Override
    public BigInteger getValueCoins() {
        return BigInteger.ZERO;
    }

    @Override
    public HashMap getExtraCurrencies() {
        return new HashMap();
    }

    ExternalMessageInInfo(long magic, MsgAddressExt srcAddr, MsgAddressInt dstAddr, BigInteger importFee) {
        this.magic = magic;
        this.srcAddr = srcAddr;
        this.dstAddr = dstAddr;
        this.importFee = importFee;
    }

    public static ExternalMessageInInfoBuilder builder() {
        return new ExternalMessageInInfoBuilder();
    }

    public MsgAddressExt getSrcAddr() {
        return this.srcAddr;
    }

    public MsgAddressInt getDstAddr() {
        return this.dstAddr;
    }

    public BigInteger getImportFee() {
        return this.importFee;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setSrcAddr(MsgAddressExt srcAddr) {
        this.srcAddr = srcAddr;
    }

    public void setDstAddr(MsgAddressInt dstAddr) {
        this.dstAddr = dstAddr;
    }

    public void setImportFee(BigInteger importFee) {
        this.importFee = importFee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalMessageInInfo)) {
            return false;
        }
        ExternalMessageInInfo other = (ExternalMessageInInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        MsgAddressExt this$srcAddr = this.getSrcAddr();
        MsgAddressExt other$srcAddr = other.getSrcAddr();
        if (this$srcAddr == null ? other$srcAddr != null : !this$srcAddr.equals(other$srcAddr)) {
            return false;
        }
        MsgAddressInt this$dstAddr = this.getDstAddr();
        MsgAddressInt other$dstAddr = other.getDstAddr();
        if (this$dstAddr == null ? other$dstAddr != null : !this$dstAddr.equals(other$dstAddr)) {
            return false;
        }
        BigInteger this$importFee = this.getImportFee();
        BigInteger other$importFee = other.getImportFee();
        return !(this$importFee == null ? other$importFee != null : !((Object)this$importFee).equals(other$importFee));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalMessageInInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        MsgAddressExt $srcAddr = this.getSrcAddr();
        result = result * 59 + ($srcAddr == null ? 43 : $srcAddr.hashCode());
        MsgAddressInt $dstAddr = this.getDstAddr();
        result = result * 59 + ($dstAddr == null ? 43 : $dstAddr.hashCode());
        BigInteger $importFee = this.getImportFee();
        result = result * 59 + ($importFee == null ? 43 : ((Object)$importFee).hashCode());
        return result;
    }

    public String toString() {
        return "ExternalMessageInInfo(magic=" + this.getMagic() + ", srcAddr=" + String.valueOf(this.getSrcAddr()) + ", dstAddr=" + String.valueOf(this.getDstAddr()) + ", importFee=" + String.valueOf(this.getImportFee()) + ")";
    }

    public static class ExternalMessageInInfoBuilder {
        private long magic;
        private MsgAddressExt srcAddr;
        private MsgAddressInt dstAddr;
        private BigInteger importFee;

        ExternalMessageInInfoBuilder() {
        }

        public ExternalMessageInInfoBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ExternalMessageInInfoBuilder srcAddr(MsgAddressExt srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public ExternalMessageInInfoBuilder dstAddr(MsgAddressInt dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public ExternalMessageInInfoBuilder importFee(BigInteger importFee) {
            this.importFee = importFee;
            return this;
        }

        public ExternalMessageInInfo build() {
            return new ExternalMessageInInfo(this.magic, this.srcAddr, this.dstAddr, this.importFee);
        }

        public String toString() {
            return "ExternalMessageInInfo.ExternalMessageInInfoBuilder(magic=" + this.magic + ", srcAddr=" + String.valueOf(this.srcAddr) + ", dstAddr=" + String.valueOf(this.dstAddr) + ", importFee=" + String.valueOf(this.importFee) + ")";
        }
    }
}

