/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ExtBlkRef
implements Serializable {
    BigInteger endLt;
    int seqno;
    BigInteger rootHash;
    BigInteger fileHash;

    public String getRootHash() {
        return this.rootHash.toString(16);
    }

    public String getFileHash() {
        return this.fileHash.toString(16);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.endLt, 64).storeUint(this.seqno, 32).storeUint(this.rootHash, 256).storeUint(this.fileHash, 256).endCell();
    }

    public static ExtBlkRef deserialize(CellSlice cs) {
        return ExtBlkRef.builder().endLt(cs.loadUint(64)).seqno(cs.loadUint(32).intValue()).rootHash(cs.loadUint(256)).fileHash(cs.loadUint(256)).build();
    }

    ExtBlkRef(BigInteger endLt, int seqno, BigInteger rootHash, BigInteger fileHash) {
        this.endLt = endLt;
        this.seqno = seqno;
        this.rootHash = rootHash;
        this.fileHash = fileHash;
    }

    public static ExtBlkRefBuilder builder() {
        return new ExtBlkRefBuilder();
    }

    public BigInteger getEndLt() {
        return this.endLt;
    }

    public int getSeqno() {
        return this.seqno;
    }

    public void setEndLt(BigInteger endLt) {
        this.endLt = endLt;
    }

    public void setSeqno(int seqno) {
        this.seqno = seqno;
    }

    public void setRootHash(BigInteger rootHash) {
        this.rootHash = rootHash;
    }

    public void setFileHash(BigInteger fileHash) {
        this.fileHash = fileHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtBlkRef)) {
            return false;
        }
        ExtBlkRef other = (ExtBlkRef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSeqno() != other.getSeqno()) {
            return false;
        }
        BigInteger this$endLt = this.getEndLt();
        BigInteger other$endLt = other.getEndLt();
        if (this$endLt == null ? other$endLt != null : !((Object)this$endLt).equals(other$endLt)) {
            return false;
        }
        String this$rootHash = this.getRootHash();
        String other$rootHash = other.getRootHash();
        if (this$rootHash == null ? other$rootHash != null : !this$rootHash.equals(other$rootHash)) {
            return false;
        }
        String this$fileHash = this.getFileHash();
        String other$fileHash = other.getFileHash();
        return !(this$fileHash == null ? other$fileHash != null : !this$fileHash.equals(other$fileHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtBlkRef;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSeqno();
        BigInteger $endLt = this.getEndLt();
        result = result * 59 + ($endLt == null ? 43 : ((Object)$endLt).hashCode());
        String $rootHash = this.getRootHash();
        result = result * 59 + ($rootHash == null ? 43 : $rootHash.hashCode());
        String $fileHash = this.getFileHash();
        result = result * 59 + ($fileHash == null ? 43 : $fileHash.hashCode());
        return result;
    }

    public String toString() {
        return "ExtBlkRef(endLt=" + String.valueOf(this.getEndLt()) + ", seqno=" + this.getSeqno() + ", rootHash=" + this.getRootHash() + ", fileHash=" + this.getFileHash() + ")";
    }

    public static class ExtBlkRefBuilder {
        private BigInteger endLt;
        private int seqno;
        private BigInteger rootHash;
        private BigInteger fileHash;

        ExtBlkRefBuilder() {
        }

        public ExtBlkRefBuilder endLt(BigInteger endLt) {
            this.endLt = endLt;
            return this;
        }

        public ExtBlkRefBuilder seqno(int seqno) {
            this.seqno = seqno;
            return this;
        }

        public ExtBlkRefBuilder rootHash(BigInteger rootHash) {
            this.rootHash = rootHash;
            return this;
        }

        public ExtBlkRefBuilder fileHash(BigInteger fileHash) {
            this.fileHash = fileHash;
            return this;
        }

        public ExtBlkRef build() {
            return new ExtBlkRef(this.endLt, this.seqno, this.rootHash, this.fileHash);
        }

        public String toString() {
            return "ExtBlkRef.ExtBlkRefBuilder(endLt=" + String.valueOf(this.endLt) + ", seqno=" + this.seqno + ", rootHash=" + String.valueOf(this.rootHash) + ", fileHash=" + String.valueOf(this.fileHash) + ")";
        }
    }
}

