/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.InMsg;
import org.ton.java.tlb.MsgEnvelope;

public class EnqueuedMsg
implements InMsg,
Serializable {
    BigInteger enqueuedLt;
    MsgEnvelope outMsg;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.enqueuedLt, 64).storeRef(this.outMsg.toCell()).endCell();
    }

    public static EnqueuedMsg deserialize(CellSlice cs) {
        return EnqueuedMsg.builder().enqueuedLt(cs.loadUint(64)).outMsg(MsgEnvelope.deserialize(CellSlice.beginParse((Cell)cs.loadRef()))).build();
    }

    EnqueuedMsg(BigInteger enqueuedLt, MsgEnvelope outMsg) {
        this.enqueuedLt = enqueuedLt;
        this.outMsg = outMsg;
    }

    public static EnqueuedMsgBuilder builder() {
        return new EnqueuedMsgBuilder();
    }

    public BigInteger getEnqueuedLt() {
        return this.enqueuedLt;
    }

    public MsgEnvelope getOutMsg() {
        return this.outMsg;
    }

    public void setEnqueuedLt(BigInteger enqueuedLt) {
        this.enqueuedLt = enqueuedLt;
    }

    public void setOutMsg(MsgEnvelope outMsg) {
        this.outMsg = outMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnqueuedMsg)) {
            return false;
        }
        EnqueuedMsg other = (EnqueuedMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$enqueuedLt = this.getEnqueuedLt();
        BigInteger other$enqueuedLt = other.getEnqueuedLt();
        if (this$enqueuedLt == null ? other$enqueuedLt != null : !((Object)this$enqueuedLt).equals(other$enqueuedLt)) {
            return false;
        }
        MsgEnvelope this$outMsg = this.getOutMsg();
        MsgEnvelope other$outMsg = other.getOutMsg();
        return !(this$outMsg == null ? other$outMsg != null : !((Object)this$outMsg).equals(other$outMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnqueuedMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $enqueuedLt = this.getEnqueuedLt();
        result = result * 59 + ($enqueuedLt == null ? 43 : ((Object)$enqueuedLt).hashCode());
        MsgEnvelope $outMsg = this.getOutMsg();
        result = result * 59 + ($outMsg == null ? 43 : ((Object)$outMsg).hashCode());
        return result;
    }

    public String toString() {
        return "EnqueuedMsg(enqueuedLt=" + String.valueOf(this.getEnqueuedLt()) + ", outMsg=" + String.valueOf(this.getOutMsg()) + ")";
    }

    public static class EnqueuedMsgBuilder {
        private BigInteger enqueuedLt;
        private MsgEnvelope outMsg;

        EnqueuedMsgBuilder() {
        }

        public EnqueuedMsgBuilder enqueuedLt(BigInteger enqueuedLt) {
            this.enqueuedLt = enqueuedLt;
            return this;
        }

        public EnqueuedMsgBuilder outMsg(MsgEnvelope outMsg) {
            this.outMsg = outMsg;
            return this;
        }

        public EnqueuedMsg build() {
            return new EnqueuedMsg(this.enqueuedLt, this.outMsg);
        }

        public String toString() {
            return "EnqueuedMsg.EnqueuedMsgBuilder(enqueuedLt=" + String.valueOf(this.enqueuedLt) + ", outMsg=" + String.valueOf(this.outMsg) + ")";
        }
    }
}

