/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;

public class CurrencyCollection
implements Serializable {
    BigInteger coins;
    TonHashMapE extraCurrencies;

    public Cell toCell() {
        Cell dict = null;
        if (Objects.nonNull(this.extraCurrencies)) {
            dict = this.extraCurrencies.serialize(k -> CellBuilder.beginCell().storeUint(((Long)k).longValue(), 32).endCell().getBits(), v -> CellBuilder.beginCell().storeVarUint((BigInteger)v, 5).endCell());
        }
        return CellBuilder.beginCell().storeCoins(this.coins).storeDict(dict).endCell();
    }

    public static CurrencyCollection deserialize(CellSlice cs) {
        return CurrencyCollection.builder().coins(cs.loadCoins()).extraCurrencies(cs.loadDictE(32, k -> k.readUint(32).longValue(), v -> CellSlice.beginParse((Cell)v).loadVarUInteger(BigInteger.valueOf(5L)))).build();
    }

    CurrencyCollection(BigInteger coins, TonHashMapE extraCurrencies) {
        this.coins = coins;
        this.extraCurrencies = extraCurrencies;
    }

    public static CurrencyCollectionBuilder builder() {
        return new CurrencyCollectionBuilder();
    }

    public BigInteger getCoins() {
        return this.coins;
    }

    public TonHashMapE getExtraCurrencies() {
        return this.extraCurrencies;
    }

    public void setCoins(BigInteger coins) {
        this.coins = coins;
    }

    public void setExtraCurrencies(TonHashMapE extraCurrencies) {
        this.extraCurrencies = extraCurrencies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CurrencyCollection)) {
            return false;
        }
        CurrencyCollection other = (CurrencyCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$coins = this.getCoins();
        BigInteger other$coins = other.getCoins();
        if (this$coins == null ? other$coins != null : !((Object)this$coins).equals(other$coins)) {
            return false;
        }
        TonHashMapE this$extraCurrencies = this.getExtraCurrencies();
        TonHashMapE other$extraCurrencies = other.getExtraCurrencies();
        return !(this$extraCurrencies == null ? other$extraCurrencies != null : !this$extraCurrencies.equals(other$extraCurrencies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CurrencyCollection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $coins = this.getCoins();
        result = result * 59 + ($coins == null ? 43 : ((Object)$coins).hashCode());
        TonHashMapE $extraCurrencies = this.getExtraCurrencies();
        result = result * 59 + ($extraCurrencies == null ? 43 : $extraCurrencies.hashCode());
        return result;
    }

    public String toString() {
        return "CurrencyCollection(coins=" + String.valueOf(this.getCoins()) + ", extraCurrencies=" + String.valueOf(this.getExtraCurrencies()) + ")";
    }

    public static class CurrencyCollectionBuilder {
        private BigInteger coins;
        private TonHashMapE extraCurrencies;

        CurrencyCollectionBuilder() {
        }

        public CurrencyCollectionBuilder coins(BigInteger coins) {
            this.coins = coins;
            return this;
        }

        public CurrencyCollectionBuilder extraCurrencies(TonHashMapE extraCurrencies) {
            this.extraCurrencies = extraCurrencies;
            return this;
        }

        public CurrencyCollection build() {
            return new CurrencyCollection(this.coins, this.extraCurrencies);
        }

        public String toString() {
            return "CurrencyCollection.CurrencyCollectionBuilder(coins=" + String.valueOf(this.coins) + ", extraCurrencies=" + String.valueOf(this.extraCurrencies) + ")";
        }
    }
}

