/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.Counters;

public class CreatorStats
implements Serializable {
    long magic;
    Counters mcBlocks;
    Counters shardBlocks;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(4, 4).storeCell(this.mcBlocks.toCell()).storeCell(this.shardBlocks.toCell()).endCell();
    }

    public static CreatorStats deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).longValue();
        assert (magic == 4L) : "CreatorStats: magic not equal to 0x4, found 0x" + Long.toHexString(magic);
        return CreatorStats.builder().magic(4L).mcBlocks(Counters.deserialize(cs)).shardBlocks(Counters.deserialize(cs)).build();
    }

    CreatorStats(long magic, Counters mcBlocks, Counters shardBlocks) {
        this.magic = magic;
        this.mcBlocks = mcBlocks;
        this.shardBlocks = shardBlocks;
    }

    public static CreatorStatsBuilder builder() {
        return new CreatorStatsBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public Counters getMcBlocks() {
        return this.mcBlocks;
    }

    public Counters getShardBlocks() {
        return this.shardBlocks;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setMcBlocks(Counters mcBlocks) {
        this.mcBlocks = mcBlocks;
    }

    public void setShardBlocks(Counters shardBlocks) {
        this.shardBlocks = shardBlocks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatorStats)) {
            return false;
        }
        CreatorStats other = (CreatorStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        Counters this$mcBlocks = this.getMcBlocks();
        Counters other$mcBlocks = other.getMcBlocks();
        if (this$mcBlocks == null ? other$mcBlocks != null : !((Object)this$mcBlocks).equals(other$mcBlocks)) {
            return false;
        }
        Counters this$shardBlocks = this.getShardBlocks();
        Counters other$shardBlocks = other.getShardBlocks();
        return !(this$shardBlocks == null ? other$shardBlocks != null : !((Object)this$shardBlocks).equals(other$shardBlocks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreatorStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        Counters $mcBlocks = this.getMcBlocks();
        result = result * 59 + ($mcBlocks == null ? 43 : ((Object)$mcBlocks).hashCode());
        Counters $shardBlocks = this.getShardBlocks();
        result = result * 59 + ($shardBlocks == null ? 43 : ((Object)$shardBlocks).hashCode());
        return result;
    }

    public String toString() {
        return "CreatorStats(magic=" + this.getMagic() + ", mcBlocks=" + String.valueOf(this.getMcBlocks()) + ", shardBlocks=" + String.valueOf(this.getShardBlocks()) + ")";
    }

    public static class CreatorStatsBuilder {
        private long magic;
        private Counters mcBlocks;
        private Counters shardBlocks;

        CreatorStatsBuilder() {
        }

        public CreatorStatsBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public CreatorStatsBuilder mcBlocks(Counters mcBlocks) {
            this.mcBlocks = mcBlocks;
            return this;
        }

        public CreatorStatsBuilder shardBlocks(Counters shardBlocks) {
            this.shardBlocks = shardBlocks;
            return this;
        }

        public CreatorStats build() {
            return new CreatorStats(this.magic, this.mcBlocks, this.shardBlocks);
        }

        public String toString() {
            return "CreatorStats.CreatorStatsBuilder(magic=" + this.magic + ", mcBlocks=" + String.valueOf(this.mcBlocks) + ", shardBlocks=" + String.valueOf(this.shardBlocks) + ")";
        }
    }
}

