/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class Counters
implements Serializable {
    long lastUpdated;
    BigInteger total;
    BigInteger cnt2048;
    BigInteger cnt65536;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.lastUpdated, 32).storeUint(this.total, 64).storeUint(this.cnt2048, 64).storeUint(this.cnt65536, 64).endCell();
    }

    public static Counters deserialize(CellSlice cs) {
        return Counters.builder().lastUpdated(cs.loadUint(32).longValue()).total(cs.loadUint(64)).cnt2048(cs.loadUint(64)).cnt65536(cs.loadUint(64)).build();
    }

    Counters(long lastUpdated, BigInteger total, BigInteger cnt2048, BigInteger cnt65536) {
        this.lastUpdated = lastUpdated;
        this.total = total;
        this.cnt2048 = cnt2048;
        this.cnt65536 = cnt65536;
    }

    public static CountersBuilder builder() {
        return new CountersBuilder();
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    public BigInteger getCnt2048() {
        return this.cnt2048;
    }

    public BigInteger getCnt65536() {
        return this.cnt65536;
    }

    public void setLastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setTotal(BigInteger total) {
        this.total = total;
    }

    public void setCnt2048(BigInteger cnt2048) {
        this.cnt2048 = cnt2048;
    }

    public void setCnt65536(BigInteger cnt65536) {
        this.cnt65536 = cnt65536;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Counters)) {
            return false;
        }
        Counters other = (Counters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastUpdated() != other.getLastUpdated()) {
            return false;
        }
        BigInteger this$total = this.getTotal();
        BigInteger other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        BigInteger this$cnt2048 = this.getCnt2048();
        BigInteger other$cnt2048 = other.getCnt2048();
        if (this$cnt2048 == null ? other$cnt2048 != null : !((Object)this$cnt2048).equals(other$cnt2048)) {
            return false;
        }
        BigInteger this$cnt65536 = this.getCnt65536();
        BigInteger other$cnt65536 = other.getCnt65536();
        return !(this$cnt65536 == null ? other$cnt65536 != null : !((Object)this$cnt65536).equals(other$cnt65536));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Counters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastUpdated = this.getLastUpdated();
        result = result * 59 + (int)($lastUpdated >>> 32 ^ $lastUpdated);
        BigInteger $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        BigInteger $cnt2048 = this.getCnt2048();
        result = result * 59 + ($cnt2048 == null ? 43 : ((Object)$cnt2048).hashCode());
        BigInteger $cnt65536 = this.getCnt65536();
        result = result * 59 + ($cnt65536 == null ? 43 : ((Object)$cnt65536).hashCode());
        return result;
    }

    public String toString() {
        return "Counters(lastUpdated=" + this.getLastUpdated() + ", total=" + String.valueOf(this.getTotal()) + ", cnt2048=" + String.valueOf(this.getCnt2048()) + ", cnt65536=" + String.valueOf(this.getCnt65536()) + ")";
    }

    public static class CountersBuilder {
        private long lastUpdated;
        private BigInteger total;
        private BigInteger cnt2048;
        private BigInteger cnt65536;

        CountersBuilder() {
        }

        public CountersBuilder lastUpdated(long lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public CountersBuilder total(BigInteger total) {
            this.total = total;
            return this;
        }

        public CountersBuilder cnt2048(BigInteger cnt2048) {
            this.cnt2048 = cnt2048;
            return this;
        }

        public CountersBuilder cnt65536(BigInteger cnt65536) {
            this.cnt65536 = cnt65536;
            return this;
        }

        public Counters build() {
            return new Counters(this.lastUpdated, this.total, this.cnt2048, this.cnt65536);
        }

        public String toString() {
            return "Counters.CountersBuilder(lastUpdated=" + this.lastUpdated + ", total=" + String.valueOf(this.total) + ", cnt2048=" + String.valueOf(this.cnt2048) + ", cnt65536=" + String.valueOf(this.cnt65536) + ")";
        }
    }
}

